<?php

namespace App\Core\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        'App\Core\Console\Commands\Teste',        
        'App\Core\Console\Commands\VerifyBudget'
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('teste')
        //         ->withoutOverlapping()
        //         ->dailyAt('13:48')
        //         ->emailOutputTo('daniel180600@gmail.com');

        // $schedule->command('inspire')
        //          ->hourly();
        $schedule->command('VerifyBudget')->withoutOverlapping()
                ->dailyAt('00:01')
                ->emailOutputTo('daniel180600@gmail.com');
                //  ->dailyAt('00:01');

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
