<?php

namespace App\Core\Entities;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Contracts\Validation\Factory;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Support\MessageBag;

use Auth;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

use DB;
use Config;
use Session;

class InstiModel extends Model
{   
     //Auth::user();
    // protected $form;
    // protected $form_mode='adicionar';
     protected $dateFormat = 'd-m-Y H:i:s';
     public $timestamps = false;
     
     protected $fillable=[ ];
     protected $attributes =[];
     protected $rules=[];
     /**
      * 
      * @param String|Array $key  pode 
      * @param String|Array $value
      * @return Boolean
      */
     public function addRules($key, $value){
          $retorno=false;
          //Se a chave já existe não adiciona
          if(isset($this->rules[$key])){
            goto saida;
          }
          //Se a chave e o valor forem arrays 
          if(is_array($key) && is_array($value)){
               //transforma o array de chaves e valores em um array associativo e mescla com o array rules
               $this->rules=array_merge($this->rules,array_combine($keys, $values));
               goto saida;
          }
          //O nome da chave ou o valor não for string sai
          if(is_string($key)===false || is_string($value)===false){
              goto saida; 
          }
          $this->rules[$key]=$value;
          $retorno=true;
          goto saida;
          
          saida:
            return $retorno;   
     }
     
     public function setRule(){
          
     }


     public function validator($form_data, $form_rules, $messages=array(), $customAttributes=array()){
        $validatorClass=app(Factory::class); 
        return $validator = $validatorClass->make($form_data , $form_rules,  $messages, $customAttributes);  
     } 
     public function createErp($dados){
         /* $validator = $this->validator($dados , $this->form_rules);
          if ($validator->fails()) {
              $erros= $validator->errors()->all();
              $retorno['msg']=implode(". ", $erros);
             goto saida;
           }  
        return $this->create($dados);
          */
         $table_name=$this->getTable();
         dd($table_name);
         exit;
     }
     
//      public function getCreatedAtAttribute(){
//         $retorno = null;    
    
//         if(!is_null($this->attributes['created_at']) && $this->attributes['created_at']!=''){
//              // dd('teste',$this->attributes['created_at'], $this->getTable());
//              $data_format = Carbon::createFromFormat('Y-m-d H:i:s', $this->attributes['created_at']);
//              $retorno = $data_format->format('d/m/Y H:i:s');
//         }
//         return $retorno;
//    }

//    public function getUpdatedAtAttribute(){
//         $retorno = null;

//         if(!is_null($this->attributes['updated_at']) && $this->attributes['updated_at']!=''){
//              // dd('teste2',$this->attributes['updated_at']);
//              $data_format = Carbon::createFromFormat('Y-m-d H:i:s', $this->attributes['updated_at']);
//              $retorno = $data_format->format('d/m/Y H:i:s');
//         }
//         return $retorno;
//    }

                  
//    public function setCreatedAtAttribute($value){
//         // $this->attributes['created_at']=Carbon::now();//new DateTime();
//         $this->attributes['created_at']=Carbon::now()->format('Y-m-d H:i:s');//new DateTime();
//         // dd('testeeee',$this->attributes['created_at']);
//    }

//    public function setUpdatedAtAttribute($value){
//         $this->attributes['updated_at']=Carbon::now()->format('Y-m-d H:i:s');//->format($this->dateFormat);//new DateTime();
//         // dd($this->attributes['updated_at']);
//    }

      
     public function setCriadoEmAttribute($value){
          $this->attributes['criado_em']=Carbon::now();//new DateTime();
     }
     public function setIdUserAttribute($value){
        $this->attributes['id_user']=Auth::user()->id;
     }
     public function setCriadoPorAttribute($value){
         $user=Auth::user();
         $this->attributes['criado_por'] = setUsuarioNomeTruncate($user->nome);
     }
     public function setFilialAttribute($value){
       $this->attributes['filial']=$value;
     }
     public function setModificadoEmAttribute($value){
          $this->attributes['modificado_em']=Carbon::now();//new DateTime();
     }
     public function setIdUserModificadoAttribute($value){
        $this->attributes['id_user_modificado']=Auth::user()->id;
     }
     public function setModificadoPorAttribute($value){
         $user=Auth::user();
         $this->attributes['modificado_por'] = setUsuarioNomeTruncate($user->nome);
     }
     public function setCodEmpresaAttribute($value){
          $this->attributes['cod_empresa']=$value;
     }
     public function setCodEstabAttribute($value){
        $this->attributes['cod_estab']=$value;
     }
     
    public function getNomeTabela(){ return $this->getTable(); }
    public function getNomeChavePrimaria(){ return $this->getKeyName(); } 
    public function getConnectionConfigByOwner($owner){
         $connections_list=config('database.connections'); 
         $retorno=[];
         foreach($connections_list as $k=>$v){
             if($v['username']==$owner){
                 $retorno=['name'=>$k, 'config'=>$v];
                 break;
             }
         }
         return count($retorno)==0 ? false : $retorno;
    }
    public function getNomeColunas(){
        $tb_info=explode('.',$this->getNomeTabela());
        $c=$this->getConnectionName();
        $scheme='';
        $tb_name='';
       
        if(empty($c)){
            if(count($tb_info)>1){
                 $tb_name=$tb_info[1];
                $config=$this->getConnectionConfigByOwner($tb_info[0]);
                if(is_array($config)){
                    $scheme=$config['name'];
                }
            }
            else{
               $tb_name=$tb_info[0];
            }
        }
        else{
            $tb_name=$tb_info[0];
            $scheme=$c;
        }
       
        $a=\DB::connection($scheme)->getSchemaBuilder()->getColumnListing($tb_name);
        
        $collumns=[];
        
        foreach($a as $k=>$v){
        	if(is_string($v)){
				$collumns[]=strtolower($v);
			}
			else{
				if(isset($a['column_name'])===true){
					$collumns[]= strtolower($v['column_name']);			
				}
			}
		}
      
        saida:
        return $collumns;
    }
    
      /**
     *
     * @return ARRAY com o nome dos campos antecedido pelo nome da tabela
     */
    public function getColunaAlias($coluna){
         $tb_name=$this->getNomeTabela();
         $colunas=$this->getNomeColunas();

          if(empty($colunas)===true){
            return $coluna;
          }
          if(in_array($coluna,$colunas)===false){
               return $coluna;
          }
          return $tb_name.'.'.$coluna;
    }
     /**
     * 
     * @param STRING|ARRAY $coluna OPCIONAL pode ser uma string reprensentando uma coluna ou um array simples representando varias colunas
     * @return string
     */
    public function getColunasAlias($coluna=''){
         $tb_name=$this->getNomeTabela();
         $colunas=$this->getNomeColunas();
         if(empty($colunas)){
              return '';
         }
         
        if(empty($coluna)==false){
            if(is_array($coluna)){
               $colunas= array_intersect($coluna, $colunas);
            }
            else{
                if(in_array($coluna,$colunas)===false){
                   return $coluna;
                }
            }
        }
        
         return array_map(function ($campo) use($tb_name){
               return $tb_name.'.'.$campo;
         }, $colunas);
    } 
     
}
