<?php

namespace App\Core\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Symfony\Component\HttpKernel\Exception\UnauthorizedHttpException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {
        //return parent::render($request, $exception);
        
          if (!$request->ajax() && !$request->wantsJson()){
           return parent::render($request, ($exception instanceof TokenMismatchException)? new HttpException(401, 'Sessão expirada recarregue a página') 
                   : $exception);
        }
        
        $http_code=400;
        $is_debug=config('app.debug');//$_ENV['APP_DEBUG'];
        $out_put= [
              'success' => false,
              'status'=>'error',
              'msg'=>$exception->getMessage(),
              'submsg'=>'',
              'debug'=>''
        ];
        
        
        if($is_debug==true){
            $out_put['debug'] = [
                                'code' => $exception->getCode(),
                                'message' => $exception->getMessage(),
                                'aquivo'=>$exception->getFile(),
                                'linha'=>   $exception->getLine(),
                                'trace'=> $exception->getTraceAsString()
                                ];
        }
        
         
        if ($exception instanceof HttpResponseException) {
               $out_put['msg']=$exception->getResponse().'Erro: 190820191741';
        }
        elseif ($exception instanceof ModelNotFoundException) {
          
            $exception = new NotFoundHttpException($exception->getMessage(), $exception);
            $http_code=404;
            $out_put['msg']=$exception->getMessage().'Erro: 190820191742';//$e->getResponse();
        }
        elseif ($exception instanceof UnauthorizedHttpException) {
            $preException = $exception->getPrevious();
            if ($preException instanceof
                          \Tymon\JWTAuth\Exceptions\TokenExpiredException) {
                $out_put['msg']='Token expirado. Recarregue a página e faça o login novamente. Os dados não salvos serão perdidos.';
                $out_put['submsg']='Erro: TOKEN_EXPIRED 210820190810.';
            } else if ($preException instanceof
                          \Tymon\JWTAuth\Exceptions\TokenInvalidException) {
                $out_put['msg']='Token invalido. Recarregue a página e faça o login novamente. Os dados não salvos serão perdidos.';
                $out_put['submsg']='Erro: TOKEN_INVALID 210820190811.';
            } else if ($preException instanceof
                     \Tymon\JWTAuth\Exceptions\TokenBlacklistedException) {
                 $out_put['msg']='Token bloqueado. Recarregue a página e faça o login novamente. Os dados não salvos serão perdidos.';
                 $out_put['submsg']='Erro: TOKEN_BLACK_LIST 210820190812.';
           }
           elseif($exception->getMessage() === 'Token not provided') {
               $out_put['msg']='Token não aprovado. Recarregue a página e faça o login novamente. Os dados não salvos serão perdidos.';
               $out_put['submsg']='Erro: TOKEN_NOT_APROVED 210820190813.';
           }
        }
        elseif ($exception instanceof AuthorizationException)
        {
           
            $http_code=301;
            $out_put['msg']= 'É necessário efetuar o login';
            $out_put['submsg']='Recarregue a página. Os dados não salvas serão perdidas. Erro: 190820191743';
        }
        elseif($exception instanceof TokenMismatchException)
        {           
            $http_code=403;
            $out_put['msg']= 'Sessão expirada recarregue a página';
            $out_put['submsg']='Os dados não salvas serão perdidas. Erro: 190820191744';
        }
        elseif($exception instanceof ValidationException && $exception->getResponse())
        {
          
            $out_put['msg']= $exception->getResponse();
        }
        elseif($exception instanceof NotFoundHttpException)
        {
            $out_put['msg']='Página não encontrada';
            $out_put['submsg']='Erro:190820191745. Endereço requisitado '.$request->url();
            $http_code=404;
        }
        elseif($exception instanceof HttpException){
          
            $http_code=$exception->getStatusCode();
            //$out_put['msg']
            //Symfony\Component\HttpKernel\Exception\HttpException
        }else{
            //$encode=mb_detect_encoding( $e->getMessage());
            //$http_code=404;
            //$out_put['msg']= utf8_encode(str_to_clipper($e->getMessage()));//$e->getResponse();
            //$out_put['msg']=$e->xdebug_message;
        }

       
        
        if( $out_put['msg']==''){
           $out_put['msg']='Falha ao executar operação solicitada.';
           $out_put['submsg']='Recarregue a página e tente novamente. Os dados não salvas serão perdidas. Erro: 190820191746<br>'
                   . ''.((string) $exception );
           //dd($exception );
        }
        return response()->json($out_put, $http_code);
        
        //return parent::render($request, $exception);
    }
}
