<?php

namespace App\Core\Http\Controllers\Auth;

use App\Core\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use App\Modules\Natureza51\Repositories\RepoDefinirSenha;
use Illuminate\Http\Request;
use DB;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function recuperarSenha(Request $request){
        $data_request = $request->all();
        $email = $data_request['email'];
        $retorno=$this->getArrayRetornoDefault();        

        $dados = DB::select("select * from institb_usuario where email = ?", [$email]);

        if(count($dados)<=0){
            $retorno['msg']='Usuário não encontrado!';
            $retorno['submsg']='Erro: 231020200848';
            goto saida;
        }

        $repoDefinirSenha = new RepoDefinirSenha();

        if(!$repoDefinirSenha->enviarEmailDefinirSenha($dados[0])){ 
            $retorno['msg']=$repoDefinirSenha->getErrosFlatted();
            $retorno['submsg']='Erro: 231020200849';
            goto saida;
        }

        $retorno['status']='success';
        $retorno['msg']='Você receberá um email com um link para definir sua senha de acesso ao sistema!';
        $retorno['submsg']='Atenção';

        saida:
        return $this->retornoJsonDefault($retorno);        
    }
}
