<?php

namespace App\Core\Http\Controllers\Auth;


use App\Core\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;

use Auth;
//use  Illuminate\Session\Store;
use Session;
use Symfony\Component\HttpFoundation\Session\SessionBagInterface;
use Config;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use Carbon\Carbon;

use App\Core\Entities\TblgLog;
use GuzzleHttp\Client;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Exception\ClientException;
// use GuzzleHttp\Psr7\Request;

use App\Modules\Natureza51\Repositories\RepoDefinirSenha;
use Illuminate\Support\Facades\DB as DB;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
  
    
     /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    //use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = 'home';
    private $guard_name='insti';
    
    function getGuardname(){ 
            return 'insti';
        //return $this->getGuardByServer()!=$this->guard_name? 'INVALID_GUARD_FOR_THIS_SERVER' : $this->guard_name; 
        
    }
    private function logoutAction(){
        Session::flush();
        Auth::guard($this->getGuardname())->logout();
        return $this;
    }
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    
    public function login(Request $request){       
   
        $fail_json=function(){
            return response()->json(['status'=>'error', 'msg'=>'É necessário efetuar o login',
                                    'submsg'=>'Recarregue a página. Os dados não salvas serão perdidas. Erro: 040520191800' ],
                        301);
        };
        $fail_view=function(){ 
            $keys=csrf_field();
            //    return 'mostrando a tela de login'.$keys;
            return view('auth.login'); 
            
        };
        $okJson=function(){
            return response()->json(['status'=>'success', 
                                    'msg'=>'Login efetuado com successo',
                                    'submsg'=>'Bem-vindo.',
                                    'dados'=>[]
                                    ],
                        200);
        };
        $okView=function(){ return redirect('/home'); };
        
        if((!$request->ajax() && !$request->wantsJson())){
            $ok=$okView;
            $fail=$fail_view;
        }
        else{
            $ok=$okJson;
            $fail=$fail_json;
        }
        
         return Auth::check() ? $ok(): $fail();
    }
    
    public function logout(){
       $this->logoutAction();
	    return redirect('login');
    }

    public function getApiToken($client){
        
        $body = array('username' => 'finplan_nat51', 'password'=>'finplan_nat51@insti2020');
        try {
            $response = $client->post('api/auth', [
                'auth' => ['API_MRN', ';M6s6Ja98_3<!hh#'],
                'json' => $body
            ]);
            $token = json_decode($response->getBody()->getContents())->data->token;
        // } catch (ClientException $e) {
            
        //     return false;
        // }
        } catch (\GuzzleHttp\Exception\GuzzleException $e) {
            return false;
        }

        return $token;
    }

    public function loginIntegrado($credentials){
        $client = new Client([
            'base_uri' => 'http://api.mrn.com.br/',
        ]);

        $username = $credentials['email'];
        $password = $credentials['password'];

        $token = $this->getApiToken($client);
        if(!$token){
            return false;
        }

        $body = array('username' => $username, 'password'=>$password);
        try {
            $response = $client->post('user/auth', [
                'auth' => ['API_MRN', ';M6s6Ja98_3<!hh#'],
                'headers' => ['x-access-token' => $token],
                'json' => $body,
                'timeout' => 15, // Response timeout             
            ]);
            $res = json_decode($response->getBody()->getContents());

            if($res->error){
                return false;
            }
            $result['email'] = $res->data->email;
            $result['cpf'] = $res->data->cpf;
        } catch (\GuzzleHttp\Exception\GuzzleException $e) {
            return false;
        }
        return $result;        
    }

    public function atualizaEmail($cpf, $email){
        $dados = DB::select("select * from tbl_funcionario where cpf = ?", [$cpf]);
        if( $dados[0]->email != $email){
            $atualizar = DB::update("update institb_usuario set email = ? where funcionario_id = ?", [$email, $dados[0]->id]);
            return is_numeric($atualizar) ? true : false ;
        }
        return true;
    }
    public function validateHasPassword($login){
        $dados = DB::select("select * from institb_usuario where email = ?", [$login]);

        if(count($dados)<=0){
            return [
                "msg"=> "Usuário não encontrado!",
                "submsg"=> "Erro: 221020201148"
            ];   
        }
        if(is_null($dados[0]->senha)){

            $repoDefinirSenha = new RepoDefinirSenha();

            if(!$repoDefinirSenha->enviarEmailDefinirSenha($dados[0])){  
                return [
                    "msg"=> $repoDefinirSenha->getErrosFlatted(),
                    "submsg"=> "Erro: 221020201308"
                ];  
            }

            return [
                "msg"=> "Você receberá um email com um link para definir sua senha de acesso ao sistema!",
                "submsg"=> "Erro: 221020201308"
            ];   
        }
        return true;
    }

    public function postLogin(Request $request){
        // dd("request login", $request);
        // dd(safeEncrypt(123));
        Session::flush();
        $retorno=$this->getArrayRetornoDefault();        
        $http_code=500;
        $credentials = request(['email', 'password']);
        $credentials['api_authenticated'] = false;
        

        $login=$credentials['email'];
        $password=$credentials['password'];
        
        if(empty($login)){
           $retorno['msg']='Preencha o campo email';
           $retorno['submsg']='Erro: 300820191205';
           goto saida;
        }
        // if(empty($password)){
        //    $retorno['msg']='Preencha o campo senha';
        //    $retorno['submsg']='Erro: 300820191206';
        //    goto saida;
        // }

        $api_user = $this->loginIntegrado($credentials);
        
        if($api_user){
            $credentials['api_authenticated'] = true;
            $credentials['email'] = $api_user['email'];
            $this->atualizaEmail($api_user['cpf'], $api_user['email']);
        } else {
            $res = $this->validateHasPassword($login);
            if($res !== true){                
                $retorno['msg']=$res['msg'];
                $retorno['submsg']=$res['submsg'];
                goto saida;
            }
        }


        
        // dd($credentials);

        $logou=auth()->guard($this->getGuardname())->attempt($credentials);
        

        if(!$logou){
            $retorno['msg']='Usuário e/ou senha invalido.';
            $retorno['submsg']='Erro: 300820191206';
            $http_code=401;
            goto saida;
        }
                       
        $user = Auth::guard($this->setCurrentGuard()->getGuardname())->user();
                
        $expiration_date = Carbon::parse($user->data_validade);
        //dd($user->data_validade, $expiration_date < Carbon::now());
        if($expiration_date < Carbon::now()){
            $retorno['msg']='Usuário expirado.';
            $retorno['submsg']='Erro: 011020201456';
            $http_code=401;
            goto saida;
        }

        // dd('teste', $user->getTokenObject()['token']);

        $user_data = is_array($user->getTokenObject()['token']['func_data']) ? array_merge($user->getTokenObject()['token'], $user->getTokenObject()['token']['func_data']) : $user->getTokenObject()['token'];
        $retorno['status']='success';
        $retorno['msg']='Login efetuado com sucesso!';
        $retorno['submsg']='Bem vindo.';
        $retorno['dados']=['api_authorizations'=> safeEncrypt(json_encode($user->getTokenObject())), 
        'user_data'=>$user_data];

        // dd($user_data);
        

        $http_code=200;
 
        
        saida:
            $is_view=(!$request->ajax() && !$request->wantsJson());
            
            
            if($retorno['status']=='success'){
                return $this->retornoJsonDefault($retorno, $http_code);
                //return $is_view ? redirect($this->redirectTo) : $this->retornoJsonDefault($retorno, $http_code);
            }
            else{
                return
                //          $is_view ? redirect('login')
                //         ->with(array('message' => $retorno))
                // ->withInput() :
                $this->retornoJsonDefault($retorno, $http_code);
            }
            
    }

    protected function postLoginByToken($credentials){
         //'email', 'password'
      
      $user_model = \App\InstiUser::where('email', $credentials['email'])->first();

      // Validate Company
      if(!$user_model) {
        return response()->json([
          'error' => 'Invalid credentials'
        ], 401);
      }

      // Validate Password
      if (!Hash::check($credentials['password'], $user_model->password)) {
          return response()->json([
            'error' => 'Invalid credentials'
          ], 401);
      }

      // Generate Token
      $token = JWTAuth::fromUser($user_model);

      // Get expiration time
      $objectToken = JWTAuth::setToken($token);
      $expiration = JWTAuth::decode($objectToken->getToken())->get('exp');

      return response()->json([
        'access_token' => $token,
        'token_type' => 'bearer',
        'expires_in' => JWTAuth::decode()->get('exp')
      ]);
    }

    private function setCurrentGuard(){
         //Session::set('current_guard', $this->getGuardname()); 
        session(['current_guard'=>$this->getGuardname()]); 
        return $this;
    }
}
