<?php

namespace App\Core\Http\Controllers;

use DB;
use Config;
use Auth;
use Session;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Core\Repositories\InstiRepository as InstiRepository;
use App\Modules\Natureza51\Repositories\RepoUsuario as RepoUsuario;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;
use Carbon\Carbon;

class Controller extends BaseController
{
    private $model_instance;
    private $model_caminho;
    protected $cod_tela;
    protected $repository; 
    protected $repoUsuario; 
    protected $form_rules;
    protected $rule_msg;
    protected $tree_table_setting;
    protected $tree_table_instance;
    
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
        
    use \App\Core\Traits\UserUtilsTrait;
    use \App\Core\Traits\FieldAutofillTrait;
    use \App\Core\Traits\ParamTrait;
    
    public function getRepository(){ return $this->repository; }    
    public function getRepositoryUsuario(){ return $this->repoUsuario; }  
    public function getModel(){ return $this->model_instance; }
    public function getModelCaminho(){return $this->model_caminho;}
    public function getFormRules(){ return $this->form_rules;}
    public function getRulesMsg(){ return $this->rule_msg;}
    public function getCodTela(){ return $this->cod_tela;}
    
    protected function setCodTela($value){
        $this->cod_tela=$value;
        return $this;
    }

    protected function setFormRules($value){
        $this->form_rules=$value;
        return $this;
    }
    protected function setRulesMsg($value){
        $this->rule_msg=$value;
        return $this;                
    }
    protected function setModel($model_caminho){
        $this->model_instance=new $model_caminho();
        $this->model_caminho=$model_caminho;
        return $this;
    }
    protected function setRepository(\App\Core\Repositories\Eloquent\Repository $repository){
        $this->repository=$repository;
        return $this;
    }
    protected function setRepositoryUsuario(\App\Core\Repositories\Eloquent\Repository $repository){
        $this->repoUsuario=$repository;
        return $this;
    }
    public function hasRepository(){ return empty($this->repository)===false;}
    public function hasModel(){ return empty($this->model_instance)===false;}
    protected function getRepositoryOrModel(){ return $this->hasRepository()? $this->getRepository() : $this->getModel(); }
    
     /**
     *@param String $tipo r=repository, m=model
     */
    public function getKeysName($tipo="r"){
        return $tipo=='r'? $this->getKeysNameRepository() : $this->getKeysModel();
    }
    public function getKeysModel($model_instance=null){
        $model=!$model_instance? $this->getModel() : $model_instance;
        return !$model? null : $model->getKeyName();
    }
    public function getKeysNameRepository($reposity=null){
        $repo=!$reposity ? $this->getRepository(): $reposity;
        return $this->getKeysModel($repo->getModelEntity());
    }
    public function keysCombine($data){
        $keys= is_array($kn=$this->getKeysName())?$kn : [$kn] ;
        $retorno=[];
        $num_key=[];
        foreach($keys as $k=>$key_name){
                if(!isset($data[$key_name])){
                    continue;
                }
            $retorno[$key_name]=$data[$key_name];
        }
        
        return $retorno;
        /**
        if(count($retorno)==count($keys)){
            return $retorno;
        }  
         */      
    }
    
    
    //InstiRepository $repository
    public function __construct(){ 
        $this->setRepositoryUsuario(new RepoUsuario);
        if(empty($this->repository)==false){
            $this->setModel($this->getRepository()->getModelNameSpace());
        }
    }
    
    public function buscar(){
        
    }
    
    public function listar(){
        $this->podeAcessar('listar',true,$this->getCodTela());
        $data = $this->getRepositoryOrModel()->all();
        $dados = [];
        foreach ($data as $item) {
            if(array_key_exists('created_by', $item)){
                $item['created_by_nome'] = $this->getNomeByUsuario($item['created_by']);
                $item['updated_by_nome'] = $this->getNomeByUsuario($item['updated_by']);
            }
            array_push($dados, $item);
        }
        
        return new Response(json_encode($dados), 200);
    }
   
    public function obtIdUsuario(){
        $decrypted = json_decode(safeDecrypt(request()->bearerToken()),true);
        $id_usuario = null;
        
        if( array_key_exists('token',$decrypted) ){
            if( array_key_exists('id',$decrypted['token']) ){
                $id_usuario = $decrypted['token']['id'];
                return $id_usuario;
            }
        }
        return $id_usuario;
    }
    public function insert(Request $request){
        $this->podeAcessar('inserir',true,$this->getCodTela());
        
        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all();
        // $form_data['created_by'] = $this->obtIdUsuario();
        $form_data['user_id'] = $this->obtIdUsuario();
        //$form_data['origem'] = 1;

        if(! $this->getRepositoryOrModel()->create($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 220820191723';
            goto saida;
        }
            $retorno['msg']='Registro inserido com sucesso!';
            $retorno['submsg']='Sucesso';
            $retorno['status']='success';
        
        saida:
         return $this->retornoJsonDefault($retorno); 
    }
   
    public function update(Request $request){
        $this->podeAcessar('editar',true,$this->getCodTela());
        $retorno = $this->getArrayRetornoDefault();
        $form_data = $request->all(); 

        // $form_data['updated_by'] = $this->obtIdUsuario();
        $id=$form_data['id'];
        if(! $this->getRepositoryOrModel()->update($form_data, $id)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao atualizar o registro. Erro: 260820191038.';
                goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function delete(Request $request){
        $this->podeAcessar('deletar',true,$this->getCodTela());


       $retorno=$this->getArrayRetornoDefault();
       $form_data=$request->all(); 
       
       if(!isset($form_data['id'])){
            $retorno['msg']='Registro não encontrado';
            $retorno['submsg']='Falha ao deletar o registro. Erro: 190920191839';
            goto saida;
       }

       if(!$this->getRepositoryOrModel()->delete($form_data['id'])){
            $retorno['msg']= $this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Atualize a página e tente novamente. Erro: 260820191038.';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro excluído com sucesso!";
        saida:
        return $this->retornoJsonDefault($retorno);
    }
    
    
    //  public function podeAcessar($nome_metodo, $has_all=false, $with_abort=true){
       
    //      return true;
         /*
        $tags=implode(',',$this->getTagsByMethod($nome_metodo));
        $msg='você não tem permissão para executar este comando. '.$tags;
         
        if(empty($tags)){
            goto aborrt;
        }
        
        $user=$this->getUserFromCurrentGuard();
        
        if($user->cannot('rules', [$tags, $has_all])){
            goto aborrt;
        }
        
        return true;
         
        aborrt:
            return $with_abort===false? false : app()->abort(403, $msg);
        
        */
        
    // }
    
    public function getGuardByServer(){
        
    }
     public function getHttpCodeByStatus($array_retorno){
        if(!isset($array_retorno['status'])){
            return 500;
        }
        return $array_retorno['status']=='success' ? 200: 500;
    }
     public function retornoJsonDefault($retorno, $http_code_force=0){
         return new Response(json_encode($retorno), $http_code_force>0 ? $http_code_force : $this->getHttpCodeByStatus($retorno)); 
    }
     public function getArrayRetornoDefault(){ return ['status'=>'error', 'msg'=>'', 'submsg'=>'']; }

     /**
      * ================== FUNCOES PARA A CLASSE TREETABLE ==============
      * @TODO ALUISIO FERREIRA DE SOUSA 12/12/2019
      */
     
    public function getTreeTableSetting(){ return $this->tree_table_setting;}
    protected function setTreeTableSetting($value){
        $this->tree_table_setting=$value;
        return $this;    
    }
    public function hasTreeTableSetting(){ return empty($this->tree_table_setting)? false: true;}
    protected function newTreeTable($dados){
        $this->tree_table_instance=$this->hasTreeTableSetting() ? new AtmTreeTable($this->getTreeTableSetting(), $dados) :  null;
        return $this;
    }
    protected function getTreeTable(){ return $this->tree_table_instance;}
    public function hasTreeTable(){ return !$this->tree_table_instance? false: true;}
    public function treeTableCollumnsFromAttributes($param=null){
        $dados=empty($param) ? $this->getRepositoryOrModel()->getModelEntity() : $param;
        
        $process=function($attr){
            $retorno=[];
            foreach($attr as $k=>$v){
                $retorno[]=['field_out'=>$v];
            }
            return count($retorno)==0 ? false : $retorno;
        };
        
        if($dados instanceof \Illuminate\Support\Collection){
            $f=$dados->first();
            return !$f ? false : $process(array_keys($f->getAttributes()));
        }
        elseif(is_array($dados)){
            return $process(array_keys(reset($dados)));
        }
        elseif(method_exists($dados, 'getAttributes')) {
            return $process(array_keys($dados->getAttributes()));            
        }
        return false;
    }
    public function horaAtual(){
        return Carbon::now()->format('Y-m-d H:i:s');
    }
    public function getNomeByUsuario($user_id){
        if(!$user_id) return null;
        $user = $this->getRepositoryUsuario()->getModelEntity()->find($user_id);
        return !$user ? null : $user->nome;
     }
     

    public function formataData($array, $label){
        $data = $array[$label];
        $ano = substr($data, 0, 4);
        $meses = substr($data, 5, 2);
        $dia = substr($data, 8, 2);
        $data = $dia.'/'.$meses.'/'.$ano;
        return $data;
    }   
}
