<?php

namespace App\Core\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Support\ServiceProvider;
use App\Core\Factory;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
        $this->app->singleton(\Illuminate\Database\Eloquent\Factory::class,
                function(){
                    return Factory::construct(\Faker\Factory::create('pt_BR'),
                            [ 'app/Modules/Natureza51/database/factories'
                            ]);
                });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        
        $gate->define('tag', function ($user, $tag, $all=false) {
                if($user->isRoot()){
                return true;
          }
          
            $user_tags = $user->getUserTags();
                
             if(is_array($user_tags)===false){
                     return false;
              }
            //Se a tag for uma string transformar em um array
                if(is_string($tag)){
                $tag=explode(',',$tag);
            	}
                if($all===true){
                    foreach($tag as $k=>$v){
                        if( !in_array($v, $user_tags)){
                            return false;
                        }
                     }
                     return true;
                }
		foreach($tag as $k=>$v){
                    if( in_array($v, $user_tags) ){
			return true;
                    }
                }
             return false;

        });
    }
}
