<?php

namespace App\Core\Traits;

use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Log;


trait ErrorTrait
{
   private $error=[];
   private $sub_error=[];
     
    protected function clearError(){
        $this->error=[];
        return $this;
    }
    protected function setError($value){
        if(is_array($value)){
            $this->error=$value;
        }
        $this->error[]=$value;
        return $this;
    }
    public function getError(){ return $this->error;}

    public function getErrosFlatted(){
        $erros=$this->getError();
        $str_out="";

        foreach ($erros as $k=>$v){
            $sufix=is_array($v) ? implode('<br>', $v) : $v;
            $str_out.=($str_out==""? "": "<br>").$sufix;
        }
        return $str_out;
    }
    public function hasError(){
        $error=$this->getError();
        return count($error)>0;
    }

    protected function clearSubError(){
        $this->sub_error=[];
        return $this;
    }
    protected function setSubError($value){
        if(is_array($value)){
            $this->sub_error=$value;
        }
        $this->sub_error[]=$value;
        return $this;
    }
    public function getSubError(){ return $this->sub_error;}

    public function getSubErrosFlatted(){
        $erros=$this->getSubError();
        $str_out="";

        foreach ($erros as $k=>$v){
            $sufix=is_array($v) ? implode('<br>', $v) : $v;
            $str_out.=($str_out==""? "": "<br>").$sufix;
        }
        return $str_out;
    }
    public function hasSubError(){
        $error=$this->getSubError();
        return count($error)>0;
    }
}