<?php

namespace App\Core\Traits;

use Auth;
use Carbon\Carbon;

trait FieldAutofillTrait
{
   function fillCriadoEm($value=''){
          return Carbon::now()->format('ymd H:i:s');// Y-m-d H:i:s
     }
     function fillCriadoEmStr($value=''){
          return Carbon::now()->format('d/m/Y');
     }
     function fillOrigemSistema(){
          return 1;
     }
     function fillHoraStr($value=''){
          return Carbon::now()->format('H:i:s');
     }
     function fillIdUser($value=''){
        return $this->getUserFromCurrentGuard() ? $this->getUserFromCurrentGuard()->id : $value ;
     }
      function fillCriadoPor($value=''){
          $user=$this->getUserFromCurrentGuard();
          return $user? $user->id : $value;
     }
     function fillLogin($value=''){
         $user=$this->getUserFromCurrentGuard();
         return $user? $user->login : $value;
     }
     function fillFilial($value=''){
       return $value;
     }
     protected function fillModificadoEm($value=''){
          return Carbon::now()->format('ymd H:i:s');// Y-m-d H:i:s
     }
     protected function fillIdUserModificado($value=''){
        return $this->getUserFromCurrentGuard() ? $this->getUserFromCurrentGuard()->id : $value;
     }
     protected function fillModificadoPor($value=''){
          $user=$this->getUserFromCurrentGuard();
          return $user? $user->id : $value;
     }
     protected function fillCodEmpresa($value=''){
          $user=$this->getUserFromCurrentGuard();
          return $user? $user->id_empresa : $value;
     }
     protected function fillCodEstab($value=''){
             return $value;
     }

     public function fillAutoFieldsInsert(){
          return [
                    'created_by'=>$this->fillCriadoPor(),
                    'created_at'=>$this->fillCriadoEm(), 
                    'empresa_id'=>$this->fillCodEmpresa(),
                    'origem'=>$this->fillOrigemSistema(),
                 ];
     }

     public function fillAutoFieldsUpdate(){
          return [
                    'updated_at'=>$this->fillModificadoEm(),
                    'updated_by'=>$this->fillModificadoPor()
                 ];
     }

     public function fillAutoFields(){
          return  array_merge($this->fillAutoFieldsInsert(), $this->fillAutoFieldsUpdate());
     }     
     public function mergeWithAutoFields($fields, $for_update=false){
          
          if($for_update==='all'){
               return array_merge($fields, $this->fillAutoFields());
          }
          return array_merge($fields, $for_update===true ? $this->fillAutoFieldsUpdate() : $this->fillAutoFieldsInsert());
     }
    
}
