<?php

namespace App\Core\Traits;
use Carbon\Carbon;

trait NotificacaoTrait
{   
    public function getMessageReleaseHC(){
        return 'O orçamento já foi liberado e você ja pode iniciar o preenchimento do headcount.';
    }
    public function getMessageReleaseOrc(){
        return 'O orçamento já foi liberado e você ja pode iniciar o preenchimento do headcount.';
    }

    public function getMessageSendSystemHC(){
        return 'O headcount foi enviado automaticamente pelo sistema pois foi atingida sua data limite.';
    }

    public function getMessageSendHC($nome_lotacao){
        return "A lotação $nome_lotacao enviou seu headcount.";
    }

    public function getMessageReabreForecastLotac($nome_lotacao){
        return "A lotacao $nome_lotacao reabriu se Forecast.";
    }

    public function getMessageReabreForecast($periodo){
        return "O Forecast de período $periodo foi reaberto.";
    }

    public function getMessageliberarForecast($orc_desc, $periodo){
        return "O orçamento $orc_desc foi liberado para o preenchimento do Forecast no período $periodo.";
    }

    public function getMessageNotifTimeHC($dias){
        return "Dentro de $dias dias o orçamento será enviado automaticamente pelo sistema pois atingirá sua data limite.";
    }

    public function getMessageReopenLotac(){
        return "Seu orçamento foi reaberto.";
    }

    public function getMessageReopenLotacRH($lotacao){
        return "O orçamento da lotação $lotacao foi reaberto.";
    }

    public function getMessageSendRH(){
        return "Uma nova lotação enviou seu headcount.";
    }

    public function getMessageSend(){
        return "Seu headcount foi enviado. Aguarde até que o mesmo seja calculado.";
    }

    public function getMessageReleaseLotac(){
        return 'Seu orçamento já foi calculado e liberado para sua aprovação.';
    }

    public function getMessageApproveManager(){
        return 'Um gestor já aprovou seu orçamento.';
    }

    public function getMessageApproveDirector(){
        return 'O diretor aprovou seu orçamento!.';
    }

    public function getMessageConferLotac(){
        return 'O RH conferiu seu headcount e em breve ele será calculado.';
    }

    public function getMessageConferLotacRh($lotacao){
        return "O headcount da lotação $lotacao foi conferido e já pode ser calculado.";
    }

    public function getMessageCalculateLotac($lotacao){
        return "O orçamento da lotação $lotacao foi calculado e já pode ser liberado.";
    }
    
    public function getMessageSendForecast($nome_lotacao){
        return "A lotação $nome_lotacao enviou seu forecast.";
    }
    public function insertNotify($user_id, $message, $orc_id, $method, $tipo, $observacao=''){
        if(is_array($user_id)){
            $data = [];
            foreach ($user_id as $id => $menssagem) {
                $data_aux = [
                    'user_id' => $id,
                    'orc_id' => $orc_id,
                    'mensagem' => $menssagem,
                    'l_ok' => 0,
                    'metodo_origem' => $method,
                    'tipo'=>$tipo,
                    'observacao'=>$observacao
                ];
                array_push($data, $data_aux);
            }
        }
        else{        
            $data = array([
                'user_id' => $user_id,
                'orc_id' => $orc_id,
                'mensagem' => $message,
                'l_ok' => 0,
                'metodo_origem' => $method,
                'tipo'=>$tipo,
                'observacao'=>$observacao

            ]);
        }
        // if(!$this->getRepoNotification()->create($data)){
        if(!$this->getRepoNotification()->getModelEntity()->insert($data)){
            $this->preencherArquivoLog("Ocorreu uma falha ao inserir a notificação.". $this->getRepoNotification()->getErrosFlatted());
            return false;
        }
        return true;
    }

    
    public function getTipoMessage($handle){
        $tipos = [
            'handleReleaseHC' => 'Liberar headcount',
            'handleSendHeadcount' => 'Envio sistêmico headcount',
            'handleNotifTimeHC' => 'Notificar envio headcount',
            'handleReopenLotac' => 'Reabrir headcount',
            'notifySendRH' => 'Envio headcount',
            'notifyReopen' => 'Reabertura do headcount',
            'notifyConfer' => 'Conferição de Headcount',
            'notifyReleased' => 'Liberação do headcount calculado',
            'notifyApproveManager' => 'Aprovação do gestor',
            'notifyApproveDirector' => 'Aprovação do diretor',
            'notifyReleaseOrc' => 'Liberação do orçamento',
            'notifyConferRh' => 'Conferição de Headcount',
            'notifyTrocaLotacao' => 'Transferência de Lotação',
            'notifyCcustoVencido' => 'Centro de Custo Vencido',



            'notifyReleaseBudget' => 'Liberação do orçamento',
            'notifyTimeFillHC' => 'Notificar envio headcount',
            'notifySystemSend' => 'Envio sistêmico headcount',
            'notifySendHC' => 'Envio do headcount',
            'notifyReopen' => 'Reabertura do headcount',
            'notifyConfer' => 'Conferição de Headcount',
            'notifyRelease' => 'Liberação do orçamento',
            'notifyApproveManager' => 'Aprovação do gestor',
            'notifyApproveDirector' => 'Aprovação do diretor',
            'notifyConferRh' => 'Conferição de Headcount',
            'notifyCalculate' => 'Cálculo de Headcount',
            
            'notifySendForecast' => 'Envio do Forecast',
            'notifyReabreForecast' => 'Reabertura do Forecast',
            'notifyLiberarForecast' => 'Liberação do Orçamento para o Forecast',

            'sendNotifyApproveManager' => 'Envio headcound para aprovação do Gestor'
        ];

        return $tipos[$handle];
    }

}