<?php

namespace App\Core\Traits;

use App\Modules\Natureza51\Entities\Parametros;
use App\Modules\Natureza51\Entities\NivelHierarquico;
use App\Modules\Natureza51\Entities\Orcamento;


trait ParamTrait
{

    public function getParametros(){
        return Parametros::get();
    }

    public function getCodHierarquia(){
        return 'HIER';
    }

    public function getCodDiasNotificarFimHeadCount(){
        return 'DSNTHC';
    }

    // public function getCodDiasNotificarFimHeadCount(){
    //     return 'DSNTHC';
    // }

    public function getCodTipoHeadcount(){
        return 'TPHEADCOUNT';
    }

    public function getCodPassaRH(){
        return 'PassRH';
    }
    public function getCodPassaRHForecast(){
        return 'PassRhForecast';
    }

    public function getCodPlanLotac(){
        return 'PlanLotac';
    }

    public function getCodLinkDefinirSenha(){
        return 'linkDefinirSenha';
    }

    public function getCodEnviaEmail(){
        return 'enviaEmail';
    }


    public function getParamValue($codigoParam){
        $param = Parametros::where('cod_parametro', $codigoParam)->first();

        return $param->valor_default;
    }

    public function getParamByOrc($orc_id, $cod, $callback = null){
        $orc = Orcamento::with([
            'getOrcParametros'=>function($query){
                return $query->with(['getParametro']);
            }
        ])
        ->find($orc_id);
        
        if(is_array($orc)){
            for ($i=0; $i < count($orc['get_orc_parametros']); $i++) { 
                if($orc['get_orc_parametros'][$i]['get_parametro']['cod_parametro']==$cod){
                    return (!is_null($callback)) ? $this->$callback($orc['get_orc_parametros'][$i]['valor_parametro']) : $orc['get_orc_parametros'][$i]['valor_parametro'];
                }                
            }
        }   
        if(is_object($orc)){
            foreach ($orc->getOrcParametros as $parametro) {
                if($parametro->getParametro['cod_parametro']==$cod){
                    return (!is_null($callback)) ? $this->$callback($parametro['valor_parametro']) : $parametro['valor_parametro'];
                }
            }
        }   
        return (!is_null($callback)) ? $this->$callback($this->getParamValue($cod)) : $this->getParamValue($cod);
    }

    public function getCodOptionHierar($cod){
        $array = [
            'DirPres'   => 0,
            'DirArea'   => 1,
            'GerArea'   => 2,
            'GerDpto'   => 3,
            'GerTec'    => 4,
            'Exec'      => 5,
        ];

        return array_key_exists($cod, $array) ? $array[$cod] : array_search($cod, $array); ;
    }

    public function getCodOptionTPHC($cod){
        $array = [
            'QuadAtual' => 0,
            'Forecast'  => 1,
            'Manual'    => 2,
        ];
        return array_key_exists($cod, $array) ? $array[$cod] : array_search($cod, $array); ;
    }


}

