<?php

namespace App\Core\Traits;
use Carbon\Carbon;

trait StatusTrait
{
 
     
    /**
     * 
     * STATUS 
     * 1 - Pendente, 2 - Liberado, 3 - Em Andamento, 4- Aprovado,  5- Excluido, 6-em Execucao,  7- Finalizido
     * STATUS APROVADO (status_aprovacao)
     * 1 - Pendente, 2 - Em Aprovacao, 3 - Rejeitado
     */
        
     public function getStatusArray(){
        return array_combine($a=[self::STATUS_PENDENTE, self::STATUS_LIBERADO, 
                self::STATUS_EM_ANDAMENTO, self::STATUS_APROVADO,
                self::STATUS_EXCLUIDO, self::STATUS_EM_EXECUCAO,
                self::STATUS_FINALIZADO], $a);
    }
    public function getStatusAprovado(){ return self::STATUS_APROVADO;}
    public function isAprovado($status=0){
        $status_atual=$status>0? $status : (!$this->has() ? 0 : $this->getAtual()->status_orc);
        return $status_atual===this.getStatusAprovado();
    }
    public function getStatusPendente(){ return self::STATUS_PENDENTE;}
    public function isPendente($status=0){
        $status_atual=$status>0? $status : (!$this->has() ? 0 : $this->getAtual()->status_orc);
        return $status_atual===this.getStatusPendente();
    }
    public function getStatusLiberado(){ return self::STATUS_LIBERADO;}
    public function isLiberado($status=0){
        $status_atual=$status>0? $status : (!$this->has() ? 0 : $this->getAtual()->status_orc);
        return $status_atual===this.getStatusLiberado();
    }
    public function getStatus($status_id){
        $status_list=$this->getStatusArray();
        return isset($status_list[$status_id]) ?  $status_list[$status_id] : 0;
    }

    
    
}