<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Str;
use Illuminate\Support\Carbon;
use DB;
use Session;
//use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
//use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;

class InstiUser extends Authenticatable{
    use Notifiable;
 //   use Authenticatable, CanResetPassword;
    
   protected $table="institb_usuario"; 
   protected $primaryKey = 'id';
   protected $dateFormat = 'd-m-Y H:i:s';
   public $timestamps = false;
   
   private $token_object;  
   private $func_repo_name_space='\App\Modules\Natureza51\Repositories\RepoFuncionario';
   private $func_repo_instance;
   private $unbox_api_key=null;
   private $func_data=null;
   private $permissions=null;
   private $lotacoes=null;
    private $perfis=null;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nome', 'email', 'senha','api_token','funcionario_id','id_empresa', 'data_validade'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'senha', 'api_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function __construct(array $attributes = []){
      
    }
    
    public function getRememberToken(){
	   return null; // not supported
    }

    public function setRememberToken($value){
	   // not supported
    }
    public function getRememberTokenName(){ return null;}
    
     public function getAuthPassword(){ return trim($this->senha); }
    
    public function getJWTIdentifier() {
        return $this->getKey();
    }
    public function getJWTCustomClaims() {
        return [];
    }
    
    public function setTokenObject(){
        $all_fields = InstiUser::select('*')->where('id',$this->id)->get()->toArray()[0];
        $expire= Carbon::now()->addHours(24)->timestamp;
        $dados_funcionario=$this->getFuncByUserId($all_fields['funcionario_id']);


        $this->id_empresa = $all_fields['id_empresa'];

        $user_fields=[
            'id'=>$this->id,
                      'nome'=>$this->nome,
                      'email'=>$this->email,
                      'tipo_user'=>$this->tipo,
                      'empresa_id'=>$this->id_empresa,
                      'data_validade'=>$this->data_validade,
                      'funcionario_id'=>$this->funcionario_id,
                      'func_data'=>$this->setFuncData(!$dados_funcionario? null: $dados_funcionario->getAttributes())->getFuncData(),
                      'permissions'=>json_encode($this->setUserTags($this->loadPermissions())->getUserTags())
                    //   'lotacoes'=>$this->setLotacoes('feito em outro lugar')->getLotacoes()  
                    ];
                    // dd($user_fields);
        $access_token= safeEncrypt(json_encode(array_merge(["time"=>time(),
                                             "expire"=>$expire,
                                             "token"=>Str::random(255),
                                             "ip"=>get_client_ip()], $user_fields)));


        // dd($access_token);
       
        $user_fields['api_token']=$access_token;
        $this->api_token=$access_token;
        $this->save();
         
        $this->token_object=[
                "expires_in"=> $expire,
                "token"=>$user_fields
        ];  
        return $this;
    }
    public function getTokenObject(){ return $this->token_object; }
    private function setUnboxApiKey(){
         $this->unbox_api_key=null;
        
        if(!$this->api_token){
            return $this;
        }
        
        $this->unbox_api_key=json_decode(safeDecrypt($this->api_token));
        
        return  $this->setFuncData($this->unbox_api_key->func_data)
                     ->setUserTags($this->unbox_api_key->permissions);  
        
    }
    public function getUnboxApiKey(){ return !$this->unbox_api_key? $this->setUnboxApiKey()->unbox_api_key : $this->unbox_api_key;} 
         
     private function setFuncData($value){
         $this->func_data=$value;
         return $this;
     }
     function getFuncData(){ return $this->func_data; }
     
    private function setLotacoes($value){
        $this->lotacoes=$value;
        return $this;
    }
    function getLotacoes(){
        return $this->lotacoes;
    }
    function getFuncRepoNameSpace(){ return $this->func_repo_name_space; }
    private function initFuncionario()
    {
          $class_name=$this->getFuncRepoNameSpace();  
        $this->func_repo_instance= new $class_name();
        return $this;
    }
    function getFuncRepoInstance(){ return !$this->func_repo_instance? $this->initFuncionario()->func_repo_instance : $this->func_repo_instance; }
   
    function getFuncByUserId($id=null){
        
        $user_id= !$id ? $this->id : $id;
        if(intval($user_id)<=0){
            return null;
        }
        $result=$this->getFuncRepoInstance()->find($user_id, 
                ['nome_funcionario','lotacao_id','nivel_hier','cdn_funcionario']);

                
        return $result;
    }
    
    /**
     * Encontra o usuario baseado em um atribuito do funcionario 
     * No momento sÃ£o permitidos os atributos id, e cdn_funcionario
     * @param type $attr
     * return BOOLEAN| USER OBJECT caso nÃ£o encontre o usuario retorna FALSE do contrario retorana a entity user
     */
    function getUserByFunc($value, $attr='id'){
        
        $attr_allows=['id', 'cdn_funcionario'];
        if( !in_array($attr, $attr_allows)){
            return false;
        }
        
        $func_model=$this->getFuncRepoInstance()->getModelEntity();
        $func_tabel_name= $func_model->getTable();
        $func_table_alias='tf';
        $func_id_alias=$func_tabel_name.'.id';// $func_model->getColunaAlias('id')
        $attr_alias=$func_tabel_name.'.'.$attr;
        $result_func=$this->join($func_tabel_name, $func_id_alias,'=', 'funcionario_id')
                ->where($attr_alias,'=',$value)
                ->first();
        
        return !$result_func? false : $result_func; 
    }
    
      /**
       * 
       * @param STRING|ARRAY $permission OPCIONAL, pode ser uma TAG(striing) ou um array indexado de TAGS
       * @return type
       */
    public function loadPermissions($p_permission=''){
        
         $permission=  array_map(function($item){
                  return "".$item."";
            }, is_array($p_permission) ? $p_permission : [$p_permission] );
            // dd($permission);
         $str_permission=(count($permission)>1)? implode(',',$permission) : $permission[0];
         $empresa_id=intval($this->id_empresa)<=0? -36 : $this->id_empresa;
         $user_id=intval($this->id) <=0 ? -36 : $this->id;
         
         $params=[$empresa_id, $user_id, $user_id];
         $where_user_id="AND ppu.usuario_id=?";
         $where_user_tag="AND pt.perfil_or_user=?";
         
         if($this->isRoot()){
            $where_user_id=" ";
            $where_user_tag=" 1=1";
            $params=[];
         }
        
        //  dd($empresa_id);
         $sql="WITH permissoes as (SELECT 
                                        p.tag_or_mod_emp, 
                                        p.tipo_origem, 
                                        p.perfil_or_user,
                                        p.pu_origem 
                                    FROM 
                                       institb_permissoes p 
                                    WHERE
                                        p.tipo_origem=1)
    	,param_tags as (SELECT 
					 mdi.modulo_id,
					 md.modulo,
					 md.descricao,
					 md.status,
					 mdi.tag_id,
                                         tg.tag,
					 tg.descricao tag_descricao,
					 tg.status tag_status
				 FROM
				 	institb_modulos md
				INNER JOIN
				 	institb_modulos_empresa mde ON md.id=mde.modulo_id 
				INNER JOIN
				 	institb_modulo_itens mdi ON md.id=mdi.modulo_id
				INNER JOIN
					institb_perm_tags tg ON mdi.tag_id=tg.id
				WHERE
					mde.empresa_id=".$empresa_id."
					AND tg.status=1
					AND md.status=1
                                       ".($str_permission==""? "": " AND tg.tag IN(".$str_permission.")")." 
    			)
                SELECT
                        modulo_id, status, tag, tag_id, tag_status
                FROM
                (
                        
                         SELECT
                                tgm.modulo_id,  tgm.status, tgm.tag, tgm.tag_id, tgm.tag_status
                         FROM
                                param_tags tgm 
                        INNER JOIN
                                permissoes pt ON pt.tag_or_mod_emp=tgm.tag_id 
                        INNER JOIN
                                institb_perfil_permissoes pp ON pp.id=pt.perfil_or_user AND pt.pu_origem=1 AND pp.empresa_id=".$empresa_id."
                        INNER JOIN
                                institb_perfil_perm_user ppu ON pp.id=ppu.perfil_perm_id
                        WHERE 
                         pp.status=1	
                        ".$where_user_id."
                        " .$where_user_tag."

                        UNION ALL

                         SELECT
                                tgm.modulo_id, tgm.status, tgm.tag, tgm.tag_id, tgm.tag_status
                        FROM
                                param_tags tgm 
                      
                        
                )	tb1	
                GROUP BY 
                        modulo_id,  status, tag, tag_id, tag_status";
        
                    //     --  INNER JOIN
                    //   --          permissoes pt ON pt.tag_or_mod_emp=tgm.tag_id  AND pt.pu_origem=2
            
        // $sql ="SELECT 
        // -- ippu.id
        // -- ,ippu.perfil_perm_id 
        // -- ,ippu.usuario_id
        // -- ,iu.nome
        // -- ,ipp.descricao
        // -- ipp.perfil
        // -- ,iptt.id_perfil
        // -- ,it.cod
        // it.descricao tela
        // ,ipt.tag
        // -- ,ipt.descricao
        // from institb_perfil_perm_user ippu
        // inner join institb_usuario iu on ippu.usuario_id = iu.id
        // inner join institb_perfil_permissoes ipp on ippu.perfil_perm_id = ipp.id
        // inner join institb_perfil_tela_tag iptt ON iptt.id_perfil = ipp.id 
        // inner join institb_perm_tags ipt on iptt.id_tag = ipt.id
        // inner join institb_tela it on iptt.id_tela = it.id
        // where ippu.usuario_id = $user_id
        // and iu.status = 1
        // and iu.id_empresa = $empresa_id
        // and ipp.status = 1
        // and ipp.empresa_id = $empresa_id
        // and ipt.status = 1
        // and it.status =1
        // and it.empresa_id = $empresa_id";
         
        $result = DB::select($sql,$params);
        return $result;
    }
    private function setUserTags($tags){
        $this->permissions=is_array($tags)?$tags: [];
        //Session::put('user_tags', $this->tags);
        return $this;
    }


    public function loadLotacoes(){
            
    }


    public function hasPermissionByTelas($tela_cod,$tag=''){
       
        // $sql="SELECT id_tag as tag_id FROM institb_tela t "
        //         . " INNER JOIN "
        //         . "institb_perfil_tela_tag tg "
        //         . " On t.id=tg.id_tela "
        //         . "WHERE "
        //         . " t.cod="."'$tela_cod'"
        //         ." and tg.id_perfil="."";

        /** VERIFICIAR EMPRESA FIXO NO CÃ“DIGO */



        $sql = "
        SELECT 
            ipp.perfil
            ,it.cod
            ,it.descricao tela
            ,ipt.tag
            from institb_perfil_perm_user ippu
            inner join institb_usuario iu on ippu.usuario_id = iu.id
            inner join institb_perfil_permissoes ipp on ippu.perfil_perm_id = ipp.id
            inner join institb_perfil_tela_tag iptt ON iptt.id_perfil = ipp.id 
            inner join institb_perm_tags ipt on iptt.id_tag = ipt.id
            inner join institb_tela it on iptt.id_tela = it.id
            where ippu.usuario_id = $this->id
            and iu.status = 1
            and iu.id_empresa = $this->id_empresa
            and ipp.status = 1
            and ipp.empresa_id = $this->id_empresa
            and ipt.status = 1
            and it.status = 1
            and it.empresa_id = $this->id_empresa
            and it.cod = '$tela_cod'
            and ipt.tag = '$tag'
        ";




        $result=DB::select($sql);
        
        // dd($result);
        if(!$result){
            return false;
        }
        
        return true;
        
        return in_array(json_decode($this->getUserTags()), $result);
    } 
    /**
     * NAO IMPLEMENTADO
     * @return type
     */
    public function isRoot(){
        $grant=array('PROGRAMACAO', 'DIRETORIA', 'PRESIDENCIA');
        return false;
        //  return in_array($this->departamento, $grant)? true : false;
    }
    public function getUserTags(){
        $this->permissions=empty($this->permissions) ? (!$this->getUnboxApiKey()? [] : $this->getUnboxApiKey()->permissions) : $this->permissions;
        return $this->permissions;
    }

    /** SELECT PARA PEGAR A LOTAÃ‡ÃƒO DO CARA LOGADO ABRAÃ‡OS */
  
//     SELECT 
//  plu.id,
//  plu.seq_ud,
//  plu.limite,
//  plu.lotacao_id,
//  l.unid_lotac,
//  l.des_unid_lotac,
//  plt.id,
//  epl.seq,
//  epl.seq_pai,
//  plt.cod_tipo,
//  plt.des_tipo

// FROM
// (


// SELECT MAX(id) id FROM tbl_plano_lotac WHERE ativo=1 ) pl
// --JOIN TABELA PLANO LOTACAO X PLANO LOTACAO TIPO
// INNER JOIN
// tbl_plano_lotac_tipo plt ON pl.id=plt.plano_lotac_id

// --JOIN TABELA PLANO LOTAÃ‡ÃƒO TIPO X PLANO LOTAÃ‡ÃƒO UNID
// INNER JOIN 
// 	tbl_plano_lotac_unid plu
// ON plt.id=plu.plano_lotac_tipo_id 

// --JOIN TABELA LOTACAO X PLANO LOTACAO UNID
// INNER JOIN
// 	tbl_lotacao l ON l.id=plu.lotacao_id

// --JOIN TABELA LOTACAO X ESTRUTURA_PLANO_LOTAC AND  ESTRUTURA_PLANO_LOTAC X PLANO_LOTAC.
// INNER JOIN 
// tbl_estrutura_plano_lotac epl ON l.id =epl.lotacao_id and epl.plano_lotacao_id = pl.id
// where seq=1400
 

	
	
// 	-- AND l.ativo=1
// 	--AND plu.seq_ud=10
// 	/* AND 
// 	(l.id=620
// 	 OR l.id=1520		
// 	)*/
// ;

// --select * from tbl_estrutura_plano_lotac



    
   
    
    
}
