<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoLotacaoStatusCalculo;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use App\Modules\Natureza51\Repositories\RepoOrcParamNatureza;
use Illuminate\Support\Facades\DB;
use Exception;
use Carbon\Carbon;

class CalculateAllLotacoes implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $orc_id;
    public $tipo_table;
    public $periodo;
    public $user_id;
    public $empresa_id;
    public $hashs;
    public $lotacoes_id;

    public $tentativas_por_lotacao = 3;

    public $tries = 3;
    public $timeout = 0;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($orc_id, $user_id, $empresa_id, $tipo_table = 'O', $periodo = NULL, $hashs = [], $lotacoes_id = null)
    {
        $this->orc_id = $orc_id;
        $this->tipo_table = $tipo_table;
        $this->periodo = $periodo;
        $this->user_id = $user_id;
        $this->empresa_id = $empresa_id;        
        $this->hashs = $hashs;         
        $this->lotacoes_id = $lotacoes_id;    
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(){        
        set_time_limit(0);
        return $this->tipo_table == 'O' ? $this->calcOrcamento() : $this->calcForecast();
    }


    public function calcOrcamento(){
        $repoOrcLotacao = new RepoOrcLotacao();
        // $lotacoes_calc = $repoOrcLotacao->getModelEntity()->with('getLotacao')->where('orcamento_id', $this->orc_id)->whereIn('status', [$repoOrcLotacao->getStatusLotPendenteDigitacao(), $repoOrcLotacao->getStatusLotReaberto(), $repoOrcLotacao->getStatusEnviado(), $repoOrcLotacao->getStatusLotConferido(), $repoOrcLotacao->getStatusLotCalculado()])->get()->toArray();
        
        $lotacoes_calc = $repoOrcLotacao->getModelEntity()->with('getLotacao')->where('orcamento_id', $this->orc_id)->whereIn('status', [$repoOrcLotacao->getStatusLotPendenteDigitacao(), $repoOrcLotacao->getStatusLotReaberto(), $repoOrcLotacao->getStatusEnviado(), $repoOrcLotacao->getStatusLotConferido(), $repoOrcLotacao->getStatusLotCalculado()]);

        if(!is_null($this->lotacoes_id)){
            $lotacoes_calc->whereIn('id', $this->lotacoes_id);
        }
        
        $lotacoes_calc = $lotacoes_calc->get()->toArray();

        $repo_status_calculo = new RepoLotacaoStatusCalculo();
        $tbl_status_calc = $repo_status_calculo->getModelEntity()->getTable();

        DB::beginTransaction();
        $query_insert = "INSERT INTO {$tbl_status_calc} (orc_lotacao_id, lotacao_descricao, status, is_historico, data_inicio_calculo, usuario_calculou, orcamento_id) VALUES ";
        $values = [];
        $cont = 0;
        foreach ($lotacoes_calc as $lotacao) {
            $cont++;
            $des_lotacao = $lotacao['get_lotacao']['unid_lotac']. ' - '. $lotacao['get_lotacao']['des_unid_lotac'];
            $query_insert = $query_insert . "(?, ?, ?, ?, ?, ?, ?),";
            $values[] = $lotacao['id'];
            $values[] = $des_lotacao;
            $values[] = 1;
            $values[] = 0;
            $values[] = null;//Carbon::now()->format('ymd H:i:s');
            $values[] = $this->user_id;
            $values[] = $this->orc_id;
            
            if($cont >= 100 || $cont == count($lotacoes_calc)){
                $query_insert = substr($query_insert, 0, -1);
                try {
                    DB::insert($query_insert, $values);
                    $query_insert = "INSERT INTO {$tbl_status_calc} (orc_lotacao_id, lotacao_descricao, status, is_historico, data_inicio_calculo, usuario_calculou, orcamento_id) VALUES ";
                    $values = [];
                    $cont = 0;
                } catch (\Exception $e) {                
                    DB::rollback();
                    // dd($res);
                    // DB::insert('insert into teste_a (nome) values (?)', [$e->getMessage()]);
                    throw new Exception($e->getMessage());
                    file_put_contents('teste_escreve_isso_porfavooooor_cathch.txt', 'olha que loucura, olha que legal '.$e->getMessage());
    
                    return false;
                }
            }
        }
        DB::commit();
        // DB::beginTransaction();   
            
        $procedures = $this->getProcedures();

        //deletar da resultados de cálculo tudo que for do orçamento, hashs_id e lotacoes selecionados, tipo table e periodo. - ok
        //criar indice na tabela por essa chave do delete - ok
        //nas procedures de calculo verificar se a tabela tbl_orc_resultados_calc esta vazia, se não estiver chamar procedure de delete. Ver se esta fazendo certo - ok
        //nas procedures de calculo executar comando 'SET LOCK_TIMEOUT 60000' - ok
        //antes do exec da procedure aqui no php, chamar o comando SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED; - ok

        $this->deleteResCalc();

        foreach ($lotacoes_calc as $lot) { 

            $tentativas = $this->tentativas_por_lotacao; 
            
            $record_status = $repo_status_calculo->getModelEntity()->where([
                ['orcamento_id', $this->orc_id],
                ['orc_lotacao_id', $lot['id']],
                ['is_historico', 0],
                ['usuario_calculou', $this->user_id],
            ])->first();
            if($record_status){
                $record_status->status = 2;
                $record_status->data_inicio_calculo = Carbon::now()->format('ymd H:i:s');
                $record_status->save();
            }

            while ($tentativas > 0) {
                try {
                    $myNull = $this->tipo_table == 'O' ? NULL : $this->periodo;
                    // $res = DB::select(DB::select(DB::raw("SET NOCOUNT ON ; exec execCalcLotacao :orc_id, :orc_lotacao_id, :p_tipo_table, :p_periodo, :user_id, :empresa_id"),[
                    //     ':orc_id' => $this->orc_id,
                    //     ':orc_lotacao_id' => $lot['id'],
                    //     ':p_tipo_table' => $this->tipo_table,
                    //     ':p_periodo' => $myNull,
                    //     ':user_id' => $this->user_id,
                    //     ':empresa_id' => $this->empresa_id,
                    // ]);

                    $lotacao_id = $lot['id'];
                    $ccusto_id = $lot['cc_custo_id'];

                    foreach ($procedures as $procedure) {   
                        $res = DB::statement(DB::raw("
                        SET NOCOUNT ON ;
                        SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
                        EXEC	[dbo].".$procedure['procedure_name']."
                            @p_empresa_id = $this->empresa_id,
                            @p_orcamento_id = $this->orc_id,
                            @p_orc_lotacao_id = $lotacao_id,
                            @p_ccusto_id = $ccusto_id,
                            @p_user_id = $this->user_id,
                            @p_hash = N'".$procedure['hash']."',
                            @p_tipo_table = '$this->tipo_table',
                            @p_periodo = NULL;        
                        ")); 
                    }
                                    
                    if($record_status){
                        $record_status->status = 3;
                        $record_status->data_fim_calculo = Carbon::now()->format('ymd H:i:s');
                        $record_status->save();
                    }

                    $lotacao = $repoOrcLotacao->getModelEntity()->find($lotacao_id);
                                    
                    if($lotacao){
                        $lotacao->status = $repoOrcLotacao->getStatusLotCalculado();
                        $lotacao->save();
                    }

                    $tentativas = 0;

                } catch (\Exception $e) { 
                    $tentativas--;       
                    
                    sleep(rand(0,5));
                    if($tentativas==0){   
                        if($record_status){
                            $record_status->status = 4;
                            $record_status->data_fim_calculo = Carbon::now()->format('ymd H:i:s');
                            $record_status->save();
                        }

                        file_put_contents('log_calculos.txt', $e->getMessage());
                
                        // file_put_contents('log_calculos.txt', date().' - '.$exception->getMessage(). '\n');
                        $repo_enviar_email = new RepoEnviarEmail();
                        
                        $data_email = [
                            'subject'=>'Erro de cálculo orçamento '.$this->orc_id,
                            'view'=>'emails.errorCalculate',
                            'error'=>$e->getMessage()
                        ];
                
                        $repo_enviar_email->enviaEmail('daniel180600@gmail.com', $data_email, true);

                    }
                    // DB::rollback();
                    // throw new Exception($e->getMessage());

                    // return false;
                }

            }

            // DB::commit();
        }

            
        return true;   
    }

    public function calcForecast(){
        $repoOrcLotacao = new RepoOrcLotacao();
        $lotacoes_calc = $repoOrcLotacao->getModelEntity()->with('getLotacao')->where('orcamento_id', $this->orc_id)
                            ->whereIn('status', [$repoOrcLotacao->getStatusLotPendenteDigitacaoFCST(), $repoOrcLotacao->getStatusLotReabertoFCST(), $repoOrcLotacao->getStatusLotEnviadoFCST(), $repoOrcLotacao->getStatusLotConferidoFCST(), $repoOrcLotacao->getStatusLotCalculadoFCST()]);

        if(!is_null($this->lotacoes_id)){
            $lotacoes_calc->whereIn('id', $this->lotacoes_id);
        }

        $lotacoes_calc = $lotacoes_calc->get()->toArray();
       
        
        $repo_status_calculo = new RepoLotacaoStatusCalculo();
        $tbl_status_calc = $repo_status_calculo->getModelEntity()->getTable();

       
        DB::beginTransaction();
        $query_insert = "INSERT INTO {$tbl_status_calc} (orc_lotacao_id, lotacao_descricao, status, is_historico, data_inicio_calculo, usuario_calculou, orcamento_id) VALUES ";
        $values = [];
        $cont = 0;
        foreach ($lotacoes_calc as $lotacao) {
            $cont++;
            $des_lotacao = $lotacao['get_lotacao']['unid_lotac']. ' - '. $lotacao['get_lotacao']['des_unid_lotac'];
            $query_insert = $query_insert . "(?, ?, ?, ?, ?, ?, ?),";
            $values[] = $lotacao['id'];
            $values[] = $des_lotacao;
            $values[] = 1;
            $values[] = 0;
            $values[] = NULL;//Carbon::now()->format('ymd H:i:s');
            $values[] = $this->user_id;
            $values[] = $this->orc_id;
            
            if($cont >= 100 || $cont == count($lotacoes_calc)){
                $query_insert = substr($query_insert, 0, -1);
                try {
                    DB::insert($query_insert, $values);
                    $query_insert = "INSERT INTO {$tbl_status_calc} (orc_lotacao_id, lotacao_descricao, status, is_historico, data_inicio_calculo, usuario_calculou, orcamento_id) VALUES ";
                    $values = [];
                    $cont = 0;
                } catch (\Exception $e) {                
                    DB::rollback();
                    // dd($res);
                    // DB::insert('insert into teste_a (nome) values (?)', [$e->getMessage()]);
                    throw new Exception($e->getMessage());
                    file_put_contents('teste_escreve_isso_porfavooooor_cathch.txt', 'olha que loucura, olha que legal '.$e->getMessage());
    
                    return false;
                }
            }

        }

        DB::commit();
        // DB::beginTransaction();

        $procedures = $this->getProcedures();
        
        
        $this->deleteResCalc();

        foreach ($lotacoes_calc as $lot) {  

            $tentativas = $this->tentativas_por_lotacao;
            
            $record_status = $repo_status_calculo->getModelEntity()->where([
                ['orcamento_id', $this->orc_id],
                ['orc_lotacao_id', $lot['id']],
                ['is_historico', 0],
                ['usuario_calculou', $this->user_id],
            ])->first();
            if($record_status){
                $record_status->status = 2;
                $record_status->data_inicio_calculo = Carbon::now()->format('ymd H:i:s');
                $record_status->save();
            }

            while ($tentativas > 0) {
                try {
                    $myNull = $this->tipo_table == 'O' ? NULL : $this->periodo;
                    $lotacao_id = $lot['id'];
                    $ccusto_id = $lot['cc_custo_id'];

                    foreach ($procedures as $procedure) {    
                        

                        $res = DB::statement(DB::raw("
                        SET NOCOUNT ON ;
                        SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
                        EXEC	[dbo].".$procedure['procedure_name']."
                            @p_empresa_id = $this->empresa_id,
                            @p_orcamento_id = $this->orc_id,
                            @p_orc_lotacao_id = $lotacao_id,
                            @p_ccusto_id = $ccusto_id,
                            @p_user_id = $this->user_id,
                            @p_hash = '".$procedure['hash']."',
                            @p_tipo_table = '$this->tipo_table',
                            @p_periodo = '$this->periodo';        
                        ")); 
                    }
                                    
                    if($record_status){
                        $record_status->status = 3;
                        $record_status->data_fim_calculo = Carbon::now()->format('ymd H:i:s');
                        $record_status->save();
                    }

                    $lotacao = $repoOrcLotacao->getModelEntity()->find($lotacao_id);
                                    
                    if($lotacao){
                        $lotacao->status = $repoOrcLotacao->getStatusLotCalculadoFCST();
                        $lotacao->save();
                    }

                    $tentativas = 0;
                } catch (\Exception $e) { 
                    $tentativas--;                                
                    if($tentativas==0){                    
                        if($record_status){
                            $record_status->status = 4;
                            $record_status->data_fim_calculo = Carbon::now()->format('ymd H:i:s');
                            $record_status->save();
                        }
    
                        file_put_contents('log_calculos.txt', $e->getMessage());
                
                        // file_put_contents('log_calculos.txt', date().' - '.$exception->getMessage(). '\n');
                        $repo_enviar_email = new RepoEnviarEmail();
                        
                        $data_email = [
                            'subject'=>'Erro de cálculo orçamento '.$this->orc_id,
                            'view'=>'emails.errorCalculate',
                            'error'=>$e->getMessage()
                        ];
                
                        $repo_enviar_email->enviaEmail('daniel180600@gmail.com', $data_email, true);

                    }
                    
                    // DB::rollback();
                    // throw new Exception($e->getMessage());

                    // return false;
                }
            }
            // DB::commit();
        }

            
        return true;   
    }
    
    public function deleteResCalc(){
        $orc_id = $this->orc_id;
        $tipo_table = $this->tipo_table;
        $periodo = $this->periodo;

        if($this->hashs != []){
            $hashs_array = array_column($this->hashs,'cta_contabil_id');            
            $hashs = implode(",", $hashs_array);
        }

        if(!is_null($this->lotacoes_id)){
            $lotacoes = implode(',', $this->lotacoes_id);
        }

        $where_hashs = $this->hashs == [] ? '' : " AND ccontabil_id in ($hashs) ";
        $where_lotacoes = is_null($this->lotacoes_id) ? '' : " AND orc_lotacao_id in ($lotacoes) ";
        $where_periodo = $tipo_table == 'O' ? " AND periodo is null " : " AND periodo = '$periodo' ";


        DB::delete("delete from tbl_orc_resultados_calc where orcamento_id = $orc_id and tipo_table = '$tipo_table' $where_periodo $where_hashs $where_lotacoes");

    }

    public function getProcedures(){
        $repo_orc_param_natureza = new RepoOrcParamNatureza();
        $tbl = $repo_orc_param_natureza->getModelEntity()->getTable();
        
        if($this->hashs == []){
            $procedures = DB::select("  
                select hash_id hash, handle_sql procedure_name from $tbl where orcamento_id = $this->orc_id
                group by hash_id, handle_sql
                order by MIN(ordem_execucao)
            ");
            
            $procedures = json_decode(json_encode($procedures),true);

            array_push($procedures, [
                "hash" => "DESPESAS_ADICIONAIS",
                "procedure_name" => "sp_hnd_despesas_adicionais"
            ]);
        }
        else{
            $hashs_array = array_column($this->hashs,'hash_id');            
            $hashs = implode("','", $hashs_array);
            
            $procedures = DB::select("  
                select hash_id hash, handle_sql procedure_name from $tbl where orcamento_id = $this->orc_id
                and hash_id in ('$hashs')
                group by hash_id, handle_sql
                order by MIN(ordem_execucao)
            ");
            
            $procedures = json_decode(json_encode($procedures),true);
            
            if(in_array('DESPESAS_ADICIONAIS', $hashs_array)){
                array_push($procedures, [
                    "hash" => "DESPESAS_ADICIONAIS",
                    "procedure_name" => "sp_hnd_despesas_adicionais"
                ]);
            }

        }

        return $procedures;
    }

    /**
     * Handle a job failure.
     *
     * @param  \Throwable  $exception
     * @return void
     */
    public function failed(Exception $exception)
    {
        // DB::rollback();
        file_put_contents('log_calculos.txt', $exception->getMessage());

        // file_put_contents('log_calculos.txt', date().' - '.$exception->getMessage(). '\n');
        $repo_enviar_email = new RepoEnviarEmail();
        
        $data_email = [
            'subject'=>'Erro de cálculo orçamento '.$this->orc_id,
            'view'=>'emails.errorCalculate',
            'error'=>$exception->getMessage()
        ];

        $repo_enviar_email->enviaEmail('daniel180600@gmail.com', $data_email, true);

    }
}
