<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoLotacaoStatusCalculo;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use App\Modules\Natureza51\Repositories\RepoOrcParamNatureza;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use App\Modules\Natureza51\Repositories\RepoNotify;

use Illuminate\Support\Facades\DB;
use Exception;
use Carbon\Carbon;

class CalculateLotacao implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $orc_id;
    public $tipo_table;
    public $periodo;
    public $user_id;
    public $empresa_id;
    public $lotacao_id;
    public $hashs;

    public $tries = 1;
    public $timeout = 0;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($orc_id, $user_id, $empresa_id, $lotacao_id, $tipo_table = 'O', $periodo = NULL, $hashs = [])
    {
        $this->orc_id = $orc_id;
        $this->tipo_table = $tipo_table;
        $this->periodo = $periodo;
        $this->user_id = $user_id;
        $this->empresa_id = $empresa_id;    
        $this->lotacao_id = $lotacao_id;      
        $this->hashs = $hashs;      
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(){        
        set_time_limit(0);
        return $this->tipo_table == 'O' ? $this->calcOrcamento() : $this->calcForecast();
    }


    public function calcOrcamento(){
        $repoOrcLotacao = new RepoOrcLotacao();
        $lot = $repoOrcLotacao->getModelEntity()->with('getLotacao')->find($this->lotacao_id)->toArray();
       
        DB::beginTransaction();   

        $procedures = $this->getProcedures();
            
        try {
            $myNull = $this->tipo_table == 'O' ? NULL : $this->periodo;
           

            $lotacao_id = $lot['id'];
            $ccusto_id = $lot['cc_custo_id'];

            foreach ($procedures as $procedure) {  
                $res = DB::statement(DB::raw("
                SET NOCOUNT ON ;
                EXEC	[dbo].".$procedure['procedure_name']."
                    @p_empresa_id = $this->empresa_id,
                    @p_orcamento_id = $this->orc_id,
                    @p_orc_lotacao_id = $lotacao_id,
                    @p_ccusto_id = $ccusto_id,
                    @p_user_id = $this->user_id,
                    @p_hash = N'".$procedure['hash']."',
                    @p_tipo_table = '$this->tipo_table',
                    @p_periodo = NULL;        
                ")); 
            }

            $lotacao = $repoOrcLotacao->getModelEntity()->find($lotacao_id);
                            
            if($lotacao){
                $lotacao->status = $repoOrcLotacao->getStatusLotCalculado();
                $lotacao->save();
            }

            $this->sendEmailSuccess($lot['get_lotacao']['des_unid_lotac']);

        } catch (\Exception $e) {                
            DB::rollback();
            // dd($res);
            // DB::insert('insert into teste_a (nome) values (?)', [$e->getMessage()]);
            throw new Exception($e->getMessage());
            file_put_contents('teste_escreve_isso_porfavooooor_cathch.txt', 'olha que loucura, olha que legal '.$e->getMessage());
            return false;
        }       

        DB::commit();
            
        return true;   
    }

    public function calcForecast(){
        $repoOrcLotacao = new RepoOrcLotacao();
        $lot = $repoOrcLotacao->getModelEntity()->with('getLotacao')->find($this->lotacao_id)->toArray();
       
        DB::beginTransaction();   

        $procedures = $this->getProcedures();
        
        try {
            $myNull = $this->tipo_table == 'O' ? NULL : $this->periodo;
           

            $lotacao_id = $lot['id'];
            $ccusto_id = $lot['cc_custo_id'];

            foreach ($procedures as $procedure) { 
                $res = DB::statement(DB::raw("
                SET NOCOUNT ON ;
                EXEC	[dbo].".$procedure['procedure_name']."
                    @p_empresa_id = $this->empresa_id,
                    @p_orcamento_id = $this->orc_id,
                    @p_orc_lotacao_id = $lotacao_id,
                    @p_ccusto_id = $ccusto_id,
                    @p_user_id = $this->user_id,
                    @p_hash = N'".$procedure['hash']."',
                    @p_tipo_table = '$this->tipo_table',
                    @p_periodo = '$this->periodo';        
                ")); 
            }

            $lotacao = $repoOrcLotacao->getModelEntity()->find($lotacao_id);
                            
            if($lotacao){
                $lotacao->status = $repoOrcLotacao->getStatusLotCalculadoFCST();
                $lotacao->save();
            }

            $this->sendEmailSuccess($lot['get_lotacao']['des_unid_lotac']);

        } catch (\Exception $e) {                
            DB::rollback();
            // dd($res);
            // DB::insert('insert into teste_a (nome) values (?)', [$e->getMessage()]);
            throw new Exception($e->getMessage());
            file_put_contents('teste_escreve_isso_porfavooooor_cathch.txt', 'olha que loucura, olha que legal '.$e->getMessage());
            return false;
        }       

        DB::commit();
            
        return true;   
    }

    public function sendEmailSuccess($nome_lotac){
        $repo_user = new RepoUsuario();

        $data_user = $repo_user->getModelEntity()->find($this->user_id);


        $repo_enviar_email = new RepoEnviarEmail();
        
        $data_email = [
            'subject'=>'Cálculo de lotação concluído',
            'view'=>'emails.calculateLotacSuccess',
            'nome'=>$data_user->nome,
            'nome_lotacao' => $nome_lotac,
        ];

        $repo_enviar_email->enviaEmail($data_user->email, $data_email);

        $repo_notificacao = new RepoNotify();        

        $repo_notificacao->insertNotify($this->user_id, "O cálculo da lotação $nome_lotac foi concluído.", $this->orc_id, 'CalculateLotacao/sendEmailSuccess', 'Lotação calculada');
    }

    public function getProcedures(){
        $repo_orc_param_natureza = new RepoOrcParamNatureza();
        $tbl = $repo_orc_param_natureza->getModelEntity()->getTable();
        
        if($this->hashs == []){
            $procedures = DB::select("  
                select hash_id hash, handle_sql procedure_name from $tbl where orcamento_id = $this->orc_id
                group by hash_id, handle_sql
                order by MIN(ordem_execucao)
            ");
            
            $procedures = json_decode(json_encode($procedures),true);

            array_push($procedures, [
                "hash" => "DESPESAS_ADICIONAIS",
                "procedure_name" => "sp_hnd_despesas_adicionais"
            ]);
        }
        else{
            $hashs_array = array_column($this->hashs,'hash_id');            
            $hashs = implode("','", $hashs_array);
            
            $procedures = DB::select("  
                select hash_id hash, handle_sql procedure_name from $tbl where orcamento_id = $this->orc_id
                and hash_id in ('$hashs')
                group by hash_id, handle_sql
                order by MIN(ordem_execucao)
            ");
            
            $procedures = json_decode(json_encode($procedures),true);
            
            if(in_array('DESPESAS_ADICIONAIS', $hashs_array)){
                array_push($procedures, [
                    "hash" => "DESPESAS_ADICIONAIS",
                    "procedure_name" => "sp_hnd_despesas_adicionais"
                ]);
            }

        }

        return $procedures;
    }

    /**
     * Handle a job failure.
     *
     * @param  \Throwable  $exception
     * @return void
     */
    public function failed(Exception $exception)
    {
        DB::rollback();
        file_put_contents('log_calculos.txt', $exception->getMessage());

        // file_put_contents('log_calculos.txt', date().' - '.$exception->getMessage(). '\n');
        $repo_enviar_email = new RepoEnviarEmail();
        
        $data_email = [
            'subject'=>'Erro de cálculo orçamento '.$this->orc_id,
            'view'=>'emails.errorCalculate',
            'error'=>$exception->getMessage()
        ];

        $repo_enviar_email->enviaEmail('daniel180600@gmail.com', $data_email, true);

    }
}
