<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoRealizado;
use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use App\Modules\Natureza51\Repositories\RepoNotify;
use App\Modules\Natureza51\Repositories\RepoUsuario;
use Illuminate\Support\Facades\DB;
use Exception;
use Carbon\Carbon;

class CalculateRealizado implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $orc_id;
    public $periodo;
    public $user_id;

    public $tries = 3;
    public $timeout = 0;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($orc_id, $user_id, $periodo = NULL)
    {
        $this->orc_id = $orc_id;
        $this->periodo = $periodo;
        $this->user_id = $user_id;
    
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(){   
        $repo_realizado = new RepoRealizado();
        $repo_orc = new RepoOrcamento();

    
        set_time_limit(0);
        DB::beginTransaction();

        $orcamento = $repo_orc->getModelEntity()->find($this->orc_id);

        $orcamento->ultimo_periodo_enviado = $this->periodo;
        $orcamento->ultimo_periodo_is_reaberto = 0;
        $orcamento->save();


        if(!$repo_realizado->execSpsFolha($this->orc_id, $this->periodo)){
            $retorno['msg']=$repo_realizado->getErrosFlatted();
            $retorno['submsg']=$repo_realizado->getSubErrosFlatted();
            DB::rollback();
            goto saida;
        }



        if(!$repo_orc->calculateRealizado($this->orc_id, $this->periodo)){
            $retorno['msg']=$repo_orc->getErrosFlatted();
            $retorno['submsg']=$repo_orc->getSubErrosFlatted();
            DB::rollback(); 
            goto saida;
        }        

        DB::commit();

        
        $this->sendEmailSuccess();
        return true;

        saida:

        $repo_enviar_email = new RepoEnviarEmail();
        
        $data_email = [
            'subject'=>'Erro de cálculo realizado',
            'view'=>'emails.errorCalculate',
            'error'=>$retorno['msg'].'<br><br><br><br>'.$retorno['submsg']
        ];

        $repo_enviar_email->enviaEmail('stella@insti.com.br', $data_email, true);

        return false;
    }

    public function sendEmailSuccess(){
        $repo_user = new RepoUsuario();

        $data_user = $repo_user->getModelEntity()->find($this->user_id);


        $repo_enviar_email = new RepoEnviarEmail();
        
        $data_email = [
            'subject'=>'Cálculo de realizado concluído',
            'view'=>'emails.calculateLotacSuccess',
            'nome'=>$data_user->nome
        ];

        $repo_enviar_email->enviaEmail($data_user->email, $data_email);

        $repo_notificacao = new RepoNotify();        

        $repo_notificacao->insertNotify($this->user_id, "O cálculo do realizado foi concluído.", $this->orc_id, 'CalculateRealizado/sendEmailSuccess', 'Realizado Calculado');
    }


    /**
     * Handle a job failure.
     *
     * @param  \Throwable  $exception
     * @return void
     */
    public function failed(Exception $exception)
    {
        // DB::rollback();
        file_put_contents('log_calculos.txt', $exception->getMessage());

        // file_put_contents('log_calculos.txt', date().' - '.$exception->getMessage(). '\n');
        $repo_enviar_email = new RepoEnviarEmail();
        
        $data_email = [
            'subject'=>'Erro de cálculo orçamento '.$this->orc_id,
            'view'=>'emails.errorCalculate',
            'error'=>$exception->getMessage()
        ];

        $repo_enviar_email->enviaEmail('stella@insti.com.br', $data_email, true);

    }
}
