<?php

namespace App\Jobs;

use App\Modules\Natureza51\Repositories\RepoEnviarEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMailUser;

class Integracao implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $email_user;
    public $nome;
    public $inicio;
    public $cta_ccusto;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($email_user, $nome, $inicio, $cta_ccusto = 0)
    {
        //
        $this->email_user = $email_user;
        $this->nome = $nome;
        $this->inicio = $inicio;
        $this->cta_ccusto = $cta_ccusto;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        if($this->cta_ccusto == 0){
            $this->escreverArquivo("\n\nIniciou o JOB - ".date("d-m-Y H:i:s"));
            $this->executaIntegracoes();
        }
        else{
            $this->escreverArquivo("\n\nIniciou o JOB - {$this->cta_ccusto} - ".date("d-m-Y H:i:s"));
            $this->executaContaCcusto();
        }
        
    }
    public function executaContaCcusto(){
        $sql = "EXEC sp_ordena_execucao :layout_id";
        $erro = false;
        try{
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':layout_id', $this->cta_ccusto, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $erro = true;
                $this->escreverArquivo("Falha ao executar a sp \"sp_int_cta_vs_ccusto_uo_v2\". Erro no execute()");
            }
        }
        catch(\Exception $e){
            $this->escreverArquivo($e->getMessage().". Erro de Catch");
            $erro = true;
        }
        $repo_enviar_email = new RepoEnviarEmail();
        if($erro == false){
            $data_email = [
                'subject' => 'Integração concluída',
                'view' => 'emails.integracao.blade',
                'nome' => $this->nome,
                'data_inicio' => $this->inicio
            ];
            $this->escreverArquivo("Terminou e vai enviar e-mail para {$this->email_user} - {$this->nome}");
            $repo_enviar_email->enviaEmail($this->email_user, $data_email);
        }
    }
    public function executaIntegracoes(){
        
        $sql = "EXEC sp_ordena_execucao";
        $erro = false;
        try{
            $stmt = DB::getPdo()->prepare($sql);
            if(!$stmt->execute()){
                $erro = true;
                $this->escreverArquivo("Falha ao executar a sp \"sp_ordena_execucao\". Erro no execute()");
            }
        }
        catch(\Exception $e){
            $this->escreverArquivo($e->getMessage().". Erro de Catch");
            $erro = true;
        }
        $repo_enviar_email = new RepoEnviarEmail();
        if($erro == false){
            $data_email = [
                'subject' => 'Cálculo de lotação concluído',
                'view' => 'emails.integracao.blade',
                'nome' => $this->nome,
                'data_inicio' => $this->inicio
            ];
            $this->escreverArquivo("Terminou e vai enviar e-mail para {$this->email_user} - {$this->nome}");
            $repo_enviar_email->enviaEmail($this->email_user, $data_email);
        }
        //return $repo_enviar_email->enviaEmail($this->email_user, $data_email);
    }

    public function escreverArquivo($string){
        $arquivo = fopen("integracao_aaaaaaaaa.txt", "a+");
        if($arquivo != false){
            fwrite($arquivo, $string." => ".date("d-m-Y H:i:s")."\n");
        }
        fclose($arquivo);
    }
}
