<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendMailUser extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    } 

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $address = env("MAIL_USERNAME","app.habitapp@gmail.com");
        $subject = $this->data['subject'];
        $name = env('MAIL_FROM_NAME','SISTEMA FINPLAN 51');
        // dd("Tomara que chegue aqui alguma vez", $address);
        // $name = 'Sistema de gestão de imóveis HabitApp';
        // dd("ate aqui ta safe");
        return $this->view($this->data['view'])
            ->from($address, $name)
            // ->cc($address, $name)
            // ->bcc($address, $name)
            // ->replyTo($address, $name)
            ->subject($subject)
            ->with($this->data);
        // return $this->view('view.name');
    }
}
