<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class Beneficio extends NaturezaEntity
{
    protected $fillable = [
        'empresa_id', 'evento_id',
        'tipo_calc', 'vlr_movto', 'formula', 'ativo', 'vlr_maximo', 'cta_ct_id',
        'created_at','created_by','updated_at','updated_by','tipo_acesso',
        'salario_corte',
        'exclusivo_admissao',
        'origem_beneficio',
        'grade_maximo',
        'valor_deducao'
    ];
      

    protected $attributes = [
        'empresa_id' => null,
        'evento_id' => null,
        'tipo_calc' => null,
        'vlr_movto' => null,
        'formula' => null,
        'ativo' => null, 
        'vlr_maximo' => null,
        'cta_ct_id' => null,
        'created_at' => null,
        'created_by' => null, 
        'updated_at' => null,
        'updated_by' => null,
        'tipo_acesso' => null,
        'salario_corte' => null,
        'exclusivo_admissao' => null,
        'origem_beneficio' => null,
        'grade_maximo' => null,
        'valor_deducao' => null
    ];
    public function getEvento(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_id','id');
    }

    protected $table = 'tbl_beneficio';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
    
}

