<?php

// namespace App\Modules\GestaoCondominio\Entities;
namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class CadastroParametros extends NaturezaEntity
{

    protected $fillable = [
        'cod_parametro',
        'descricao',
        'valor_default',
        'tipo_parametro',
        'tipo_dados',
		'updated_at', 
        'created_at',
        'user_id',
        'empresa_id',
		'updated_by',
        'created_by',
        
    ];

    protected $attributes = [
        'cod_parametro'     => null,
        'descricao'         => null,
        'valor_default'     => null,
        'tipo_parametro'    => '1',
        'tipo_dados'        => null,
		'updated_at'        => null,
		'created_at'        => null,
        'user_id'           => null,
        'empresa_id'        => null,
        'updated_by'        => null,
        'created_by'        => null,
    ];

    protected $guarded = ['id'];
    protected $table = 'tblg_parametros';

    
    public function getParametrosOptions()
    {
      return $this->hasMany('App\Modules\Natureza51\Entities\ParametrosOptions', 'parametro_id', 'id' );
    }
   
    // public $timestamps = true;



    


}
