<?php

namespace App\Modules\Natureza51\Entities;

class CcustoLotacao extends NaturezaEntity{
    protected $fillable=[
        'empresa_id',
        'unid_lotac',
        'estrutura_plano_lotac_id',
        'cod_ccusto',
        // 'per_insalub', 
        // 'per_pericul',
        'lotacao_id',
        'ccusto_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];
    protected $attributes=[
        'empresa_id'=>null,
        'unid_lotac'=>null,
        'estrutura_plano_lotac_id'=>null,
        'cod_ccusto'=>null,
        // 'per_insalub'=>null,
        // 'per_pericul'=>null,
        'lotacao_id'=>null,
        'ccusto_id'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];
    protected $table='tbl_lotacao_ccusto';

    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id','id');
    }
    public function getCcusto(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\CentroCusto','ccusto_id','id');
    }
    public function getEstruturaLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\EstruturaPlanoLotac','estrutura_plano_lotac_id','id');
    }
    const UPDATED_AT = null;
    const CREATED_AT = null;
     
}