<?php

namespace App\Modules\Natureza51\Entities;

class CentroCusto extends NaturezaEntity
{
    protected $fillable = [
        'empresa_id'
      ,'cod_ccusto'
      ,'des_ccusto'
      ,'ativo'
      ,'dat_inic_valid'
      ,'dat_fim_valid',
      'created_at',
      'created_by',
      'updated_at',
      'updated_by'
    ];

    protected $attributes = [
        'empresa_id' => null, 'cod_ccusto' => null, 'des_ccusto'=> null, 'ativo'=> null, 
        'dat_inic_valid'=> null, 'dat_fim_valid'=> null, 'origem'=> '1',
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];

    protected $table = 'tbl_ccusto';

    public function getEmpresa()
    {
      return $this->BelongsTo('App\Modules\Natureza51\Entities\Empresa', 'id', 'id' );
    }

    public function getContaContabil()
    {
      return $this->hasMany('App\Modules\Natureza51\Entities\ContaContabil', 'centro_custo_id', 'id' );
    }
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
}
