<?php
namespace App\Modules\Natureza51\Entities;

class Despesas extends NaturezaEntity
{
    protected $fillable=[
        'origem_despesa',
        'cta_contabil_id',
        'evento_id',
        'descricao',
        'valor_referencia',
        'empresa_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'

    ];
    protected $attributes=[
        'origem_despesa'=>null,
        'cta_contabil_id'=>null,
        'evento_id'=>null,
        'descricao'=>null,
        'valor_referencia'=>null,
        'empresa_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];

    public function getContaContabil(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\ContaContabil','cta_contabil_id','id');
    }
    public function getEvento(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_id','id');
    }
    protected $table='tbl_despesas';

    const UPDATE_AT=null;
    const CREATED_AT=null;
}