<?php

namespace App\Modules\Natureza51\Entities;

class Funcionario extends NaturezaEntity
{
    protected $fillable = [        
      'empresa_id', 'cdn_funcionario', 'nome_funcionario'
      ,'num_reg_func', 'tp_func', 'dat_nascimento'
      ,'dat_admis_func', 'endereco_id', 'cpf'
      ,'plano_lotac_id', 'ccusto_id', 'ccusto_id'
      ,'turma_id', 'lotacao_id', 'recebe_pericul'
      ,'recebe_insal', 'func_sindlz', 'cargo_id'
      , 'nivel_hier', 'salario'
      ,'tb_ams_vip', 'vip_dir_exec', 'dt_estabi_ini'
      ,'dt_estabi_fim', 'dat_demis_func', 'tp_estabi','pt_admissao','pt_inclusao', 'pt_alteracao','pt_total', 'origem','is_demitido',
      'created_at',
      'created_by',
      'updated_at',
      'updated_by',
      'pne',
      'cod_afast',
      'descr_afast',
      'dt_afast_ini',
      'dt_afast_fim'
    ];

    protected $attributes = [
      'empresa_id' => null, 'cdn_funcionario' => null, 'nome_funcionario' => null
      ,'num_reg_func' => null, 'tp_func' => '1', 'dat_nascimento' => null
      ,'dat_admis_func' => null, 'endereco_id' => '1', 'cpf' => null
      ,'plano_lotac_id' => null, 'ccusto_id' => '1', 'ccusto_id' => null
      ,'turma_id' => null, 'lotacao_id' => null, 'recebe_pericul' => null
      ,'recebe_insal' => null, 'func_sindlz' => null, 'cargo_id' => null
      , 'nivel_hier' => null, 'salario' => null
      ,'tb_ams_vip' => null, 'vip_dir_exec' => null, 'dt_estabi_ini' => null
      ,'dt_estabi_fim' => null,'dat_demis_func'=>null, 'tp_estabi' => null,'pt_admissao'=>null, 'pt_inclusao' =>null ,'pt_alteracao'=>null, 'pt_total'=>null, 'origem' => '1','is_demitido'=>null,
      'created_at' => null,
      'created_by' => null,
      'updated_at' => null,
      'updated_by' => null,
      'pne' => null,
      'cod_afast' => null,
      'descr_afast' => null, 
      'dt_afast_ini' => null,
      'dt_afast_fim' => null
    ];
 
   public function getCargo(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Cargo','cargo_id', 'id');
   }  
   public function getCcusto(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\CentroCusto','ccusto_id', 'id');
   } 
   public function getLotacao(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id','id');
   }
   public function getTurma(){
     return $this->belongsTo('App\Modules\Natureza51\Entities\Turma','turma_id','id');
   }
   public function getTpFunc(){
     return $this->belongsTo('App\Modules\Natureza51\Entities\TpFuncionario','tp_func','id');
   }
   public function getUsuario(){
     return $this->hasOne('App\Modules\Natureza51\Entities\Usuario','funcionario_id','id');
   }
   public function getPlanoLotacao(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\PlanoLotacao','plano_lotac_id','id');
   }
    public function getCriado(){
     return $this->belongsTo('App\Modules\Natureza51\Entities\Usuario','created_by','id');
    }
    public function getAtualizado(){
     return $this->belongsTo('App\Modules\Natureza51\Entities\Usuario','updated_by','id');
    }
  //  public function getTpFunc(){
  //    return $this->belongsTo('App\Modules\Natureza51\Entities\TpFuncionario','tp_func','id');
  //  }

    protected $table = 'tbl_funcionario';
    
    const UPDATED_AT = null;
    const CREATED_AT = null;
}