<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;


class LotacaoCCusto extends NaturezaEntity
{
    protected $fillable=[
        'empresa_id',
        'unid_lotac',
        'estrutura_plano_lotac_id',
        'cod_ccusto',
        'lotacao_id',
        'ccusto_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];
    protected $attributes=[
        'empresa_id'=>null,
        'unid_lotac'=>null,
        'estrutura_plano_lotac_id'=>null,
        'cod_ccusto'=>null,
        'lotacao_id'=>null,
        'ccusto_id'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];

    protected $guarded = ['id'];

    // protected $primaryKey = array('empresa_id', 'unid_lotac', 'cod_ccusto');
    protected $table = 'tbl_lotacao_ccusto';

    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','unid_lotac', 'unid_lotac');
    }

    public function getEstruturaPlanoLotac(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\EstruturaPlanoLotac','estrutura_plano_lotac_id', 'id');
    }

    public function getCentroCusto(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\CentroCusto','cod_ccusto', 'cod_ccusto');
    }
   const UPDATED_AT = null;
   const CREATED_AT = null;
}
