<?php

namespace App\Modules\Natureza51\Entities;

class MenuItem extends NaturezaEntity
{    
    protected $fillable = [         
        'menu_id', 'parent_id', 'label', 'tipo', 'icone', 'url_fragment',
        'url_base', 'tela_id', 'tag_id', 'user_id', 'empresa_id', 'sequencia',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];
    protected $attributes=[
        'menu_id' =>null, 'parent_id' =>null, 'label' =>null, 'tipo' =>null, 'icone' =>null, 
        'url_fragment' =>null, 'url_base' =>null, 'tela_id' =>null, 'tag_id' =>null, 'user_id' =>null, 
        'empresa_id' =>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null  
        ];

    protected $table = 'institb_menu_item';
    
    const UPDATED_AT = null;
    const CREATED_AT = null; 

    public function getMenu(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Menu','menu_id', 'id');
    }
   
}
