<?php

namespace App\Modules\Natureza51\Entities;

class ModeloRelatorio extends NaturezaEntity
{
    
    protected $fillable = [ 
        'nome', 'observacao', 'tipo', 'tipo_exibir','nivel_agrupamento','visibilidade','created_at','created_by','updated_at','updated_by', 'empresa_id', 'tipo_visualizacao', 'agrupar_apenas_forecast'
    ];

    protected $attributes = [
        'nome'=>null,
        'observacao'=>null,
        'tipo'=>null,
        'tipo_exibir'=>null,
        'nivel_agrupamento'=>null,
        'visibilidade'=>null,
        'created_at'=>null,
        'created_by'=>null,
        'updated_at'=>null,
        'updated_by'=>null,
        'empresa_id'=>null,
        'tipo_visualizacao'=>null,
        'agrupar_apenas_forecast'=>null
    ];
    
    protected $guarded = ['id'];
    protected $table = 'tbl_modelo_relatorio';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
   

   public function getModeloRelatorioComparacao(){
    return $this->hasMany('App\Modules\Natureza51\Entities\ModeloRelatorioComparacao','modelo_relatorio_id');
   }
   public function getModeloRelatorioOrcamento(){
    return $this->hasMany('App\Modules\Natureza51\Entities\ModeloRelatorioOrcamento','modelo_relatorio_id');
   }   
   public function criadoPor(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Usuario','created_by');
   }
}
 