<?php

namespace App\Modules\Natureza51\Entities;

class ModeloRelatorioComparacao extends NaturezaEntity
{
    
    protected $fillable = [ 
        'modelo_relatorio_id', 'modelo_relatorio_orcamento_origem_id', 'modelo_relatorio_orcamento_destino_id', 'campo_comparar_origem','campo_comparar_destino','created_at','created_by','updated_at','updated_by', 'empresa_id'
    ];

    protected $attributes = [
        'modelo_relatorio_id'=>null,
        'modelo_relatorio_orcamento_origem_id'=>null,
        'modelo_relatorio_orcamento_destino_id'=>null,
        'campo_comparar_origem'=>null,
        'campo_comparar_destino'=>null,
        'created_at'=>null,
        'created_by'=>null,
        'updated_at'=>null,
        'updated_by'=>null,
        'empresa_id'=>null,
    ];
    
    protected $guarded = ['id'];
    protected $table = 'tbl_modelo_relatorio_comparacao';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;

   public function getModeloRelatorio(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\ModeloRelatorioComparacao','modelo_relatorio_id');
   }
   
   public function getModeloRelatorioOrcamentoOrigem(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\ModeloRelatorioOrcamento','modelo_relatorio_orcamento_origem_id');
   }
   
   public function getModeloRelatorioOrcamentoDestino(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\ModeloRelatorioOrcamento','modelo_relatorio_orcamento_destino_id');
   }
}
 