<?php

namespace App\Modules\Natureza51\Entities;

class ModeloRelatorioOrcamento extends NaturezaEntity
{
    
    protected $fillable = [ 
        'orcamento_id', 'modelo_relatorio_id', 'tipo','created_at','created_by','updated_at','updated_by', 'empresa_id', 'periodo'
    ];

    protected $attributes = [
        'orcamento_id'=>null,
        'modelo_relatorio_id'=>null,
        'tipo'=>null,
        'created_at'=>null,
        'created_by'=>null,
        'updated_at'=>null,
        'updated_by'=>null,
        'empresa_id'=>null,
        'periodo'=>null
    ];
    
    protected $guarded = ['id'];
    protected $table = 'tbl_modelo_relatorio_orcamento';
    

    const UPDATED_AT = null;
    const CREATED_AT = null;
    
    
    public function getModeloRelatorio(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\ModeloRelatorioComparacao','modelo_relatorio_id');
    }
    public function getOrcamento(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento','orcamento_id');
    }
}
 