<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcBeneficio extends NaturezaEntity
{
    protected $fillable = [
        'empresa_id', 'evento_id', 'orcamento_id', 'beneficio_id',
        'tipo_calc', 'vlr_movto', 'formula', 'vlr_maximo', 'cta_ctb_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'tipo_acesso',
        'salario_corte',
        'exclusivo_admissao',
        'grade_maximo',
        'valor_deducao',
        'tipo_table',
        'periodo'
    ];
      

    protected $attributes = [
        'empresa_id' => null, 'evento_id' => null, 'orcamento_id' => null, 'beneficio_id' => null,
        'tipo_calc' => null, 'vlr_movto' => null, 'formula'=>null, 'vlr_maximo' => null, 'cta_ctb_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'tipo_acesso' => null,
        'salario_corte' => null,
        'exclusivo_admissao' => null,
        'grade_maximo' => null,
        'valor_deducao' => null,
        'tipo_table'=>null,
        'periodo'=>null
    ];

    protected $table = 'tbl_orc_beneficio';

    public function getEvento(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_id', 'id');
    }

    public function getCtaCtb(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\ContaContabil','cta_ctb_id', 'id');
    }

    public function getCalcOrcamento(){
        return $this->hasOne('App\Modules\Natureza51\Entities\CalcOrcamento','origem_id', 'id')->where('tbl_origem', 'tbl_orc_beneficio');
    }
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
    
}

