<?php

namespace App\Modules\Natureza51\Entities;

class OrcBonus extends NaturezaEntity
{
    protected $fillable = ['orc_id', 'cargo_id', 'ccusto_id','num_sal','porcentagem','user_id', 'orc_lot_id',
        'empresa_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'tipo_table',
        'periodo'
    ];

    protected $attributes=['orc_id'=>null, 'cargo_id'=>null, 'num_sal'=>null,'porcentagem'=>null,'ccusto_id'=>null, 'orc_lot_id'=>null,
        'empresa_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'tipo_table' => null,
        'periodo' => null
    ];
    
    protected $table = 'tbl_orc_bonus';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orc_id');
   }
   public function getCargo(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Cargo', 'id', 'cargo_id');
   }
   
}