<?php

namespace App\Modules\Natureza51\Entities;

class OrcCargo extends NaturezaEntity
{
    protected $fillable = [        
        'orcamento_id'
        ,'cargo_id'
        ,'sal_base'
        ,'sal_max'
        ,'sal_med'
        ,'sal_min'
        ,'data_calc'
        ,'grupo_salarial'
        ,'quadro_atual'
        ,'created_at'
        ,'user_id'
        ,'updated_at'
        ,'empresa_id'
        ,'created_by'
        ,'updated_by'
        ,'periodo'
        ,'tipo_table'
    ];
    
    protected $attributes = [
        'empresa_id' => null, 'cargo_id' => null, 'orcamento_id' => null, 'sal_base' => null,
        'sal_max' => null, 'sal_med' => null, 'sal_min' => null, 'data_calc'=>null, 
        'grupo_salarial' => null, 'quadro_atual'=>null, 'user_id'=>null, 
        'updated_at'=>null, 
        'created_at'=>null, 
        'created_by'=>null, 
        'updated_by'=>null,
        'periodo'=>null,
        'tipo_table'=>null
    ];

    protected $table = 'tbl_orc_cargo';

    public function getCargo(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Cargo','cargo_id', 'id');
    }
    public function getUsuarioCreated(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Usuario','id', 'created_by');
    }
    public function getUsuarioUpdated(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\OrcCargo','id', 'updated_by');
    }

    const UPDATED_AT = null;
    const CREATED_AT = null;
    
    public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }  
   
}