<?php

namespace App\Modules\Natureza51\Entities;

class OrcCargosAreaSal extends NaturezaEntity
{
    protected $table = 'tbl_orc_cargos_area_sal';
    protected $fillable = [ 
       'orcamento_id', 'cargo_id', 'lotacao_id', 'parametros_formula', 'sal_base', 'sal_maior', 'sal_med',
        'sal_menor', 'empresa_id','ccusto_id', 
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'periculosidade',
        'insalubridade',
        'periodo',
        'tipo_table'
   ];
    protected $attributes=['orcamento_id'=>null, 'cargo_id'=>null, 'lotacao_id'=>null, 'sal_base'=>null, 'sal_maior'=>null, 'sal_med'=>null,
        'sal_menor'=>null, 'parametros_formula'=>'1','empresa_id'=>null,'ccusto_id'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'periculosidade' => null,
        'insalubridade' => null,
        'periodo'=>null,
        'tipo_table'=>null
    ];
    
   
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }
   public function getCargo(){
       return $this->hasOne('App\Modules\Natureza51\Entities\OrcCargo', 'id', 'cargo_id');
   }
   public function getLotacao(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Lotacao', 'id','lotacao_id');
   }
   
}