<?php
namespace App\Modules\Natureza51\Entities;

class OrcDespesas extends NaturezaEntity{
    protected $fillable=[
        'empresa_id',
        'orc_id',
        'despesa_id',
        'lotacao_id',
        'centro_custo_id',
        'valor_referencia',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'tipo_table',
        'periodo'
    ];
    protected $attributes=[
        'empresa_id'=>null,
        'orc_id'=>null,
        'despesa_id'=>null,
        'lotacao_id'=>null,
        'centro_custo_id'=>null,
        'valor_referencia'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'tipo_table' => null,
        'periodo' => null
    ];
    
    const UPDATE_AT=null;
    const CREATED_AT=null;

    public function getDespesas(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Despesas','despesa_id','id');
    }
    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id','id');
    }
    protected $table='tbl_orc_despesas';
}