<?php

namespace App\Modules\Natureza51\Entities;

class OrcEventos extends NaturezaEntity
{
    
    //tbl_orc_ferias foi retirado pois não existia no BD
    protected $fillable = [
        'orcamento_id',
        'empresa_id',
        'evento_id', 
        'cdn_event', 
        'des_event',
        'inc_liquido',
        'impr_envel',
        'multiplica', 
        'dt_base_ini',
        'dt_base_fim', 
        'formula', 
        'ativo', 
        'origem', 
        'tipo_evento_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'tipo_acesso'
        ,'tipo_table'
        ,'periodo'
    ];
    
    protected $attributes=[
        'orcamento_id'=>null,
        'evento_id'=>null, 
        'cdn_event'=>'1', 
        'des_event'=>null,
        'inc_liquido'=>'1',
        'impr_envel'=>'1',
        'multiplica'=>'1', 
        'formula'=>'1', 
        'ativo'=>'1', 
        'origem'=>null, 
        'tipo_evento_id'=>'1',
        'empresa_id'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'tipo_acesso' => null
        ,'tipo_table'=>null
        ,'periodo'=>null
    ];
   protected $table = 'tbl_orc_eventos';
      
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }
   public function getEventos(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Eventos', 'id', 'evento_id');
   }
    
}
