<?php

namespace App\Modules\Natureza51\Entities;

class OrcHoraExtra extends NaturezaEntity
{
    protected $fillable = [
        'orcamento_id','evento_id',
        'empresa_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];

    protected $attributes=['orcamento_id'=>null, 'evento_id'=>null,
        'empresa_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];

    protected $primaryKey = 'id';
    protected $table = 'tbl_orc_hora_extra';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;

    public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }

   public function getEventos(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_id');
   }
    
}
