<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcLotCargoBeneficio extends NaturezaEntity
{
    protected $fillable = [
        'orcamento_id', 'orc_lotacao_id', 'orc_cargo_id', 'orc_beneficio_id',
        'ccusto_id', 'tipo_calc', 'vlr_movto', 'formula', 'vlr_maximo', 'cta_ctb_id',
        'empresa_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'tipo_table',
        'periodo'
    ];
      

    protected $attributes = [
        'orcamento_id' => null, 'orc_lotacao_id' => null, 'orc_cargo_id' => null, 'orc_beneficio_id' => null,
        'ccusto_id' => null, 'tipo_calc' => null, 'vlr_movto' => null, 'formula'=>null, 'vlr_maximo' => null, 'cta_ctb_id' => null,
        'empresa_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'tipo_table' => null,
        'periodo' => null
    ];

    protected $table = 'tbl_orc_benef_lot_carg';
    
    public function getOrcBeneficio(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\OrcBeneficio','orc_beneficio_id', 'id');
    }

    public function getOrcCargo(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\OrcCargo','orc_cargo_id', 'id');
    }

    public function getCalcOrcamento(){
        return $this->hasMany('App\Modules\Natureza51\Entities\CalcOrcamento','origem_id', 'origem_id')->where('tbl_origem', $this->getTable());
    }

    public function getCentroCusto(){
        return $this->hasOne('App\Modules\Natureza51\Entities\CentroCusto','id', 'ccusto_id');
    }

    public function getLotacao(){
        return $this->hasOne('App\Modules\Natureza51\Entities\OrcLotacao','id', 'orc_lotacao_id');
    }
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
    
}

