<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcLotacao extends NaturezaEntity
{
    protected $fillable = [
        'orcamento_id', 'lotacao_id','responder_orc', 'cc_custo_id','hc_iniciado','status', 'has_error_calc', 
        'empresa_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'status_forecast',
        'tipo_table',
        'periodo',
        'ativo'
    ];  
    
    protected $attributes=['orcamento_id'=>null,'lotacao_id'=>null, 'responder_orc'=>null, 
        'cc_custo_id'=>null, 'hc_iniciado'=>null, 'has_error_calc'=>null,
        'status' => null,
        'empresa_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'status_forecast' => null,
        'tipo_table' => null,
        'periodo' => null,
        'ativo' => null
    ];   
    

    protected $table = 'tbl_orc_lotacao';

    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id', 'id');
    }   
    public function getCentroCusto(){
        return $this->hasOne('App\Modules\Natureza51\Entities\CentroCusto','id', 'cc_custo_id');
    } 

    public function getOrcamento(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento','orcamento_id', 'id');
    }

   const UPDATED_AT = null;
   const CREATED_AT = null;
}