<?php
    namespace App\Modules\Natureza51\Entities;

class OrcMovDespesas extends NaturezaEntity
{ 
    protected $fillable = [ 
        'id', 'orc_id', 'tipo', 'ano', 'periodo', 'natureza_id','ccusto_id','jan_val','fev_val','mar_val',
        'abr_val','mai_val','jun_val','jul_val','ago_val','set_val','out_val','nov_val','dez_val'
    ];
    protected $attributes=['orc_id'=>'', 'tipo'=>'', 'ano'=>'', 'natureza_id'=>'', 'ccusto_id'=>'','jan_val'=>'','fev_val'=>'','mar_val'=>'',
    'abr_val'=>'','mai_val'=>'','jun_val'=>'','jul_val'=>'','ago_val'=>'','set_val'=>'','out_val'=>'','nov_val'=>'','dez_val'=>''];
    
    protected $table = 'tbl_orc_mov_despesas';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;

   public function getCContabil(){
    return $this->BeLongsTo('App\Modules\Natureza51\Entities\ContaContabil','natureza_id','id');
   }
   public function getCCusto(){
    return $this->BeLongsTo('App\Modules\Natureza51\Entities\CentroCusto', 'ccusto_id', 'id');
   }
}
