<?php
    namespace App\Modules\Natureza51\Entities;

class OrcMovtoStatusCCusto extends NaturezaEntity
{ 
    protected $fillable = [ 
        'orc_lotacao_id', 'user_id', 'status_anterior', 'status_atual', 'observacao','data_hora','created_at','updated_at',
        'empresa_id',
        'created_by',
        'updated_by'
    ];
    protected $attributes=[
        'orc_lotacao_id'=>null, 
        'user_id'=>null, 
        'status_anterior'=>null, 
        'status_atual'=>null, 
        'observacao'=>null,
        'data_hora'=>null,
        'created_at'=>null,
        'updated_at'=>null,
        'empresa_id' => null,
        'created_by' => null,
        'updated_by' => null
    ];
    
    protected $guarded = ['id'];

    protected $table = 'tbl_orc_movto_status_ccusto';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;

   public function getOrcLotacao(){
    return $this->BeLongsTo('App\Modules\Natureza51\Entities\OrcLotacao','orc_lotacao_id','id');
   }
   public function getUser(){
    return $this->BeLongsTo('App\Modules\Natureza51\Entities\Usuario', 'user_id', 'id');
   }
}
