<?php
    namespace App\Modules\Natureza51\Entities;

class OrcNotificacoes extends NaturezaEntity
{ 
    protected $fillable = [ 
        'user_id', 'orc_id', 'mensagem', 'l_ok', 'metodo_origem','tipo',
        'empresa_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];
    protected $attributes=[
        'user_id'=>null, 
        'orc_id'=>null, 
        'mensagem'=>null, 
        'l_ok'=>null, 
        'metodo_origem'=>null,
        'tipo'=>null,
        'empresa_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];
    
    protected $guarded = ['id'];

    protected $table = 'tbl_orc_notificacoes';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;

   public function getOrcamento(){
    return $this->BeLongsTo('App\Modules\Natureza51\Entities\Orcamento','orc_id','id');
   }
   public function getUser(){
    return $this->BeLongsTo('App\Modules\Natureza51\Entities\Usuario', 'user_id', 'id');
   }
}
