<?php
namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcParametros extends NaturezaEntity
{
  protected $fillable = [
      'parametro_id'
      ,'orcamento_id'
      ,'valor_parametro'
      ,'user_id',
      'empresa_id',
      'created_at',
      'created_by',
      'updated_at',
      'updated_by'
  ];

  protected $attributes = [
    'parametro_id' => null,
    'orcamento_id' => null,
    'valor_parametro' => null, 
    'user_id' => null, 
    'empresa_id' => null,
    'created_at' => null,
    'created_by' => null,
    'updated_at' => null,
    'updated_by' => null
  ];

  protected $guarded = ['id'];
  protected $table = 'tbl_orc_parametros';
  
  public function getOrcamento(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento','orcamento_id', 'id');
  } 

  public function getParametro(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\CadastroParametros','parametro_id', 'id');
  } 

  const UPDATED_AT = null;
  const CREATED_AT = null;    
}
