<?php
namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcTurma extends NaturezaEntity
{
    protected $fillable = [
        'orc_id'
      ,'turma_id'
      ,'turno_id'
      ,'evento_adc_id'
      ,'evento_ext_id'
      ,'user_id'
      ,'cdn_turma_trab'
      ,'des_turma_trab'
      ,'adic_noturno'
      ,'extra_noturno'
      ,'ativo'
      ,'origem'
      ,'created_at'
      ,'updated_at',
      'empresa_id',
      'created_by',
      'updated_by',
      'tipo_table',
      'periodo'
    ];

    protected $attributes = [
        'orc_id' => null
        ,'turma_id' => null
        ,'turno_id' => null
        ,'evento_adc_id' => null
        ,'evento_ext_id' => null
        ,'user_id' => '1'
        ,'cdn_turma_trab' => null
        ,'des_turma_trab' => null 
        ,'adic_noturno' => null
        ,'extra_noturno' => null
        ,'ativo' => null
        ,'origem' => null
        ,'updated_at' => null
        ,'created_at' => null,
        'empresa_id' => null,
        'created_by' => null,
        'updated_by' => null,
        'tipo_table' => null,
        'periodo' => null
        
    ];

    public function getTurno(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Turno','turno_id','id');
    }

    public function getEvento(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_adc_id','id');
    }
    
    protected $table = 'tbl_orc_turma';

    
    
}
