<?php

namespace App\Modules\Natureza51\Entities;

class Orcamento extends NaturezaEntity
{
    
   
    
    protected $fillable = [         
        'empresa_id', 'cod_orcamento', 'ano', 'descricao_orc', 'status_aprovacao',
        'responsavel_id', 'status_orc', 'versao', 'revisao', 'responsavel_tec_id',
        'created_at', 'user_id', 'updated_at','versao_desc', 'revisao_desc', 'data_inicio','data_fim','mes_ini_frc',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'ultimo_periodo_enviado',
        'ultimo_periodo_is_reaberto',
        'mostrar_orcamento'
    ];
    protected $attributes=[
        'empresa_id' =>null, 'cod_orcamento' =>null, 'ano' =>null, 'descricao_orc' =>null, 
        'status_aprovacao' =>'1', 'responsavel_id' =>null, 'status_orc' =>'1', 'versao' =>null, 
        'revisao' =>null, 'responsavel_tec_id' =>null,'created_at' =>null, 'user_id' =>null, 'updated_at' =>null,
        'versao_desc'=>null, 'revisao_desc'=>null, 'data_inicio'=>null,'data_fim'=>null,'mes_ini_frc'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null   ,
        'ultimo_periodo_enviado' => null,
        'ultimo_periodo_is_reaberto' => null ,
        'mostrar_orcamento' => 0
        ];
    // protected $guarded = ['id'];
    protected $table = 'tbl_orcamento';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getLotacaoNaturezaEventos(){
       return $this->hasMany('App\Modules\Natureza51\Entities\OrcLotacaoNaturezaEvento','orcamento_id');
   }
   public function getLotacaoOrcMovDespesas(){
    return $this->hasMany('App\Modules\Natureza51\Entities\OrcMovDespesas','orc_id');
   }
   public function getCargoAreaSalario(){
       return $this->hasMany('App\Modules\Natureza51\Entities\OrcCargosAreaSal','orcamento_id');
   }

   public function getOrcPremissas(){
       return $this->hasOne('App\Modules\Natureza51\Entities\OrcPremissas','orcamento_id');
   }

   public function getOrcParametros(){
       return $this->hasMany('App\Modules\Natureza51\Entities\OrcParametros','orcamento_id');
   }

   public function getOrcEventos(){
    return $this->hasMany('App\Modules\Natureza51\Entities\OrcEventos','orcamento_id');
   }

   public function getOrcHoraExtra(){
    return $this->hasMany('App\Modules\Natureza51\Entities\OrcHoraExtra','orcamento_id');
   }

   public function getCronograma(){
       //return $this->hasMany('App\Modules\Natureza51\Entities\OrcCargosAreaSal','orcamento_id');
   }

   
   
}
