<?php
namespace App\Modules\Natureza51\Entities;

class PlanoLotacUnid extends NaturezaEntity{
    protected $fillable=[
        'empresa_id', 'plano_lotac_tipo_id', 'lotacao_id', 'limite', 'seq_ud', 'origem', 'ativo',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];
    protected $attributes=[
        'empresa_id'=>null, 'plano_lotac_tipo_id'=>null, 'lotacao_id'=>null, 'limite'=>null, 'seq_ud'=>null, 'origem'=>'1', 'ativo'=>null,
        'empresa_id' => null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];
    protected $table='tbl_plano_lotac_unid';

    const UPDATED_AT=null;
    const CREATED_AT=null;

    public function getPlanoLotacTp(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\PlanoLotacaoTipo','plano_lotac_tipo_id','id');
    }
    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id','id');
    }
}