<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class PlanoLotacaoTipo extends NaturezaEntity
{
    protected $fillable = [
        'empresa_id',
        'plano_lotac_id',
        'cod_tipo',
        'des_tipo', 
        'limite',
        'ativo',
        'origem',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];    
        
    protected $attributes=[
        'empresa_id'=>'2',
        'plano_lotac_id'=>null,
        'cod_tipo'=>null,
        'des_tipo'=>null, 
        'limite'=>null,
        'ativo'=>null,
        'origem'=>'1',
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];
    
    //protected $primaryKey = array('cdn_empresa', 'cdn_plano_lotac', 'cod_tipo');

    public function getPlanoLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\PlanoLotacao','plano_lotac_id','id');
     }
    protected $table = 'tbl_plano_lotac_tipo';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
    
}
