<?php

namespace App\Modules\Natureza51\Entities;

class TelaTag extends NaturezaEntity
{
    use \App\Core\Traits\HasCompositePrimaryKeyTrait;
    
    protected $fillable = [ 
        'id_tela',
        'id_tag', 
        'empresa_id'
         
    ];
    protected $attributes = [
        'id_tela' => '',
        'id_tag' => '', 
        'empresa_id' => null, 
            
     ];
     public function getTela(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Tela','id_tela', 'id');
    }

    public function getTag()
    {
        return $this->belongsTo('App\Modules\Natureza51\Entities\PermissoesTag','id_tag', 'id');
    }
    
 
     protected $guarded = ['id'];
     protected $table = 'institb_tela_tag';
 
     const CREATED_AT = null;   
     const UPDATED_AT = null; 
}