<?php

namespace App\Modules\Natureza51\Entities;

class Turma extends NaturezaEntity
{
    protected $fillable = [
        'empresa_id'
      ,'turno_id'
      ,'cdn_turma_trab'
      ,'des_turma_trab'
      ,'evento_adc_id'
      ,'adic_noturno'
      ,'evento_ext_id'
      ,'extra_noturno'
      ,'origem'
      ,'ativo'
      ,'user_id',
      'created_at',
      'created_by',
      'updated_at',
      'updated_by',
      'tip_horario_turno',
      'med_dias_trab'
    ];

    protected $attributes = [
        'empresa_id' => null,'turno_id'=> null, 
        'cdn_turma_trab'=> null, 'des_turma_trab'=> null, 'evento_adc_id'=> '1', 'adic_noturno'=> null, 
        'evento_ext_id'=> '1', 'extra_noturno'=> null, 'ativo'=>'1', 'origem'=> null, 'user_id'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null,
        'tip_horario_turno'=> null, 
        'med_dias_trab'=>null
    ];
    public function getTurno(){
      return $this->belongsTo('App\Modules\Natureza51\Entities\Turno','turno_id','id');
    }
    public function getOrcTurma(){
      return $this->belongsTo('App\Modules\Natureza51\Entities\OrcTurma','id','turma_id');
    }
    public function getEvento(){
      return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_adc_id','id'); 
    }
    protected $table = 'tbl_turma';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
    
}
