<?php

namespace App\Modules\Natureza51\Entities;

class TurmaEvento extends NaturezaEntity
{
    protected $fillable = [
        'turma_id',
        'evento_id',
        'qtd_hrs',
        'empresa_id',
        'turno_id',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];  

    protected $attributes=['turma_id'=>null,
        'evento_id'=>null,
        'qtd_hrs'=>null,
        'empresa_id'=>null,
        'turno_id'=>null,
        'created_at'=>null,
        'updated_at'=>null,
        'created_by'=>null,
        'updated_by'=>null
    ];   

    protected $table = 'tbl_turma_evento';
    
    const UPDATED_AT = null;
    const CREATED_AT = null;
    
    public function getEvento(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos', 'evento_id', 'id');
    }
    public function getTurma(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Turma','turma_id','id');
    }
}
