<?php

namespace App\Modules\Natureza51\Entities;

class Usuario extends NaturezaEntity
{
    protected $defaultPassword = 123;

    protected $fillable = [
        'id_empresa','id_grupo','id_filial','id_grupo_acesso','id_permissao',
        'id_grupo_empresarial','nome','senha','email','status',
        'usuario_dominio','data_validade','data_alt_senha','numero_dias_senha',
        'tipo','funcionario_id','api_token',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];
	protected $attributes = [
        'id_empresa'=>null,'id_grupo'=>'1','id_filial'=>'1','id_grupo_acesso'=>'1',
        'id_permissao'=>'1','id_grupo_empresarial'=>'1','nome'=>null,'senha'=>null,
        'email'=>null,'status'=>null,'usuario_dominio'=>'1','data_validade'=>null,
        'data_alt_senha'=>null,'numero_dias_senha'=>null,'tipo'=>null,'funcionario_id'=>null,'api_token'=>null,
        'created_at' => null,
        'created_by' => null,
        'updated_at' => null,
        'updated_by' => null
    ];
    public function getNumReg(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Funcionario','funcionario_id','id');
    }
    public function getFuncionario(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Funcionario','funcionario_id','id');
    }

    public function getDefaultPassword(){
        return $this->defaultPassword;
    }

    protected $guarded = ['id'];
    protected $table = 'institb_usuario';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
}
